/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.profile;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.ArtefactData;
import com.tpwar.domain.avatar.AvatarItem;
import com.tpwar.domain.avatar.ShieldData;
import com.tpwar.domain.avatar.TimeWarpData;
import com.tpwar.domain.avatar.TreasureData;
import com.tpwar.domain.avatar.UnitTechData;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.TimeUtils;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.storage.Storage;
import com.tpwar.storage.avatar.ArtefactType;
import java.util.concurrent.TimeUnit;
import packet.Static;

public class InventoryWidget
extends Table {
    private final Assets assets = Assets.getInstance();
    private final Storage storage = Storage.getInstance();
    private final Model model = Model.getInstance();
    private final WindowManager windowManager = WindowManager.getInstance();
    private TextureAtlas atlas;
    private final Array<Image> items = new Array();

    public InventoryWidget() {
        this.atlas = (TextureAtlas)this.assets.get("ui/profile.atlas");
    }

    public void show() {
        int size = Math.max(15, (int)Math.ceil((float)this.items.size / 3.0f) * 3);
        for (int i = 0; i < size; ++i) {
            Stack stack = new Stack();
            stack.add(new Image(this.atlas.findRegion("empty_slot")));
            if (i < this.items.size) {
                stack.add(new Container<Image>(this.items.get(i)));
            }
            Cell<Stack> cell = this.add(stack).space(6.0f);
            if ((i + 1) % 3 != 0) continue;
            cell.row();
        }
    }

    public void addItem(AvatarItem item) {
        Static.StaticItemType itemType = this.storage.itemType.get(item.itemTypeId);
        Image image = new Image(this.atlas.findRegion(itemType.getCode().toLowerCase() + "_icon"));
        final String text = itemType.getDescription() + "\n\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u043e " + TimeUtils.convertTime(item.effectEndTime);
        image.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                WarningWindow wnd = new WarningWindow(WarningWindow.Type.INFO, "\u0411\u0443\u0441\u0442\u0435\u0440", text, "\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
                InventoryWidget.this.windowManager.open(wnd, true);
            }
        });
        this.items.add(image);
    }

    public void addItem(ArtefactData artefact) {
        ArtefactType at = artefact.getType();
        String iconName = "dead_ray_icon";
        switch (at.code) {
            case "double_power": {
                iconName = "double_power_icon";
                break;
            }
            case "dynamic_shield": {
                iconName = "dynamic_shield_icon";
                break;
            }
            case "heal": {
                iconName = "heal_icon";
            }
        }
        Image image = new Image(this.atlas.findRegion(iconName));
        final String text = this.model.lang.format("window.profile.artifact_count", at.description, artefact.count);
        image.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                WarningWindow wnd = new WarningWindow(WarningWindow.Type.INFO, "\u0410\u0440\u0442\u0435\u0444\u0430\u043a\u0442", text, "\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
                InventoryWidget.this.windowManager.open(wnd, true);
            }
        });
        this.items.add(image);
    }

    public void addItem(UnitTechData utd) {
        Static.StaticUnitTech unitTech = this.storage.techType.get(utd.unitTechTypeId);
        String nameType = "\u0443\u0440\u043e\u043d +" + unitTech.getDamage();
        String iconName = "attack_icon";
        if (unitTech.getArmor() > 0) {
            iconName = "defence_icon";
            nameType = "\u0431\u0440\u043e\u043d\u044e +" + unitTech.getArmor();
        } else if (unitTech.getHealth() > 0) {
            iconName = "health_icon";
            nameType = "\u0437\u0434\u043e\u0440\u043e\u0432\u044c\u0435 +" + unitTech.getHealth();
        }
        Image image = new Image(this.atlas.findRegion(iconName));
        final String text = "\u0422\u0435\u0445\u043d\u043e\u043b\u043e\u0433\u0438\u044f \u0443\u043b\u0443\u0447\u0448\u0430\u044e\u0449\u0430\u044f " + nameType;
        image.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                WarningWindow wnd = new WarningWindow(WarningWindow.Type.INFO, "\u0422\u0435\u0445\u043d\u043e\u043b\u043e\u0433\u0438\u044f", text, "\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
                InventoryWidget.this.windowManager.open(wnd, true);
            }
        });
        this.items.add(image);
    }

    public void addItem(TimeWarpData timeWarp) {
        Static.StaticTimeWarpType type = this.storage.timeWarp.get(timeWarp.typeId);
        long timeEnd = timeWarp.activationTime + TimeUnit.HOURS.toMillis(type.getTimeAction());
        Image image = new Image(this.atlas.findRegion(type.getSacle() < 0 ? "time_war_s" : "time_warp_f"));
        final String text = "\u0418\u0441\u043a\u0440\u0438\u0432\u0438\u0442\u0435\u043b\u044c \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043d\u0430 " + Math.abs(type.getSacle()) + (type.getSacle() < 0 ? "% \u0443\u0432\u0435\u043b\u0438\u0447\u0438\u0432\u0430\u0435\u0442" : "% \u0443\u043c\u0435\u043d\u044c\u0448\u0430\u0435\u0442") + " \u0432\u0440\u0435\u043c\u044f \u0441\u0442\u0440\u043e\u0438\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u044e\u043d\u0438\u0442\u043e\u0432. \u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u043e " + TimeUtils.convertTime(timeEnd);
        image.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                WarningWindow wnd = new WarningWindow(WarningWindow.Type.INFO, "\u0418\u0441\u043a\u0440\u0438\u0432\u0438\u0442\u0435\u043b\u044c \u0432\u0440\u0435\u043c\u0435\u043d\u0438", text, "\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
                InventoryWidget.this.windowManager.open(wnd, true);
            }
        });
        this.items.add(image);
    }

    public void addItem(TreasureData treasureData) {
        Image image = new Image(this.atlas.findRegion("treasure_icon"));
        Static.StaticZone zone = this.storage.zone.get(treasureData.zoneId);
        final String text = "\u041a\u043b\u0430\u0434 \u0437\u0430\u0440\u044b\u0442 \u043d\u0430 " + zone.getPosition() + " \u0437\u043e\u043d\u0435 \u043f\u043b\u0430\u043d\u0435\u0442\u044b \u041c\u0430\u0443\u0440\u043e";
        image.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                WarningWindow wnd = new WarningWindow(WarningWindow.Type.INFO, "\u041a\u0430\u0440\u0442\u0430", text, "\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
                InventoryWidget.this.windowManager.open(wnd, true);
            }
        });
        this.items.add(image);
    }

    public void addShield(ShieldData shieldData) {
        Image image = new Image(this.atlas.findRegion("shield_icon"));
        Static.StaticShieldType shieldType = this.storage.shieldType.get(shieldData.typeId);
        long timeEnd = shieldData.activationTime + TimeUnit.HOURS.toMillis(shieldType.getTimeAction());
        final String text = String.format("\u0429\u0438\u0442 \u0434\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u043e %s", TimeUtils.convertTime(timeEnd));
        image.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                WarningWindow wnd = new WarningWindow(WarningWindow.Type.INFO, "\u0429\u0438\u0442", text, "\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
                InventoryWidget.this.windowManager.open(wnd, true);
            }
        });
        this.items.add(image);
    }
}

