/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.quest;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.domain.avatar.AvatarQuest;
import com.tpwar.domain.avatar.AvatarQuestGoal;
import com.tpwar.game.managers.FinanceManager;
import com.tpwar.game.utils.TimeUtils;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Commander;
import io.netty.util.internal.StringUtil;
import packet.Transport;

public class QuestWindow
extends DefaultWindow
implements MessageListener {
    private final AvatarQuest avatarQuest;
    private float timerDelta;
    private boolean needUpdateTimer;
    private Label timer;
    private Cell statusCell;
    private Label status;
    private Table statusTable;

    public QuestWindow(AvatarQuest avatarQuest) {
        super("");
        this.avatarQuest = avatarQuest;
    }

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.quest"));
        Table main = new Table();
        main.defaults().space(6.0f);
        this.getContentTable().add(main).growX().pad(20.0f, 20.0f, 10.0f, 20.0f);
        long timeLeft = this.avatarQuest.getLeftTime(this.model.getServerTime());
        Table goals = new Table();
        for (AvatarQuestGoal questGoal : this.avatarQuest.goals) {
            GoalWidget goalWidget = new GoalWidget(this.avatarQuest, questGoal);
            goals.add(goalWidget).row();
        }
        this.avatarQuest.goalUpdated = false;
        this.status = new Label((CharSequence)"", new Label.LabelStyle(QuestWindow.assets.getFont().arialBold16, Color.valueOf("#D92121")));
        NinePatchDrawable statusBackground = assets.getNinePatchDrawable(assets.getCommonAtlas(), "blurred_background", 50, 50, 6, 6);
        this.statusTable = new Table();
        this.statusTable.setBackground(statusBackground);
        this.statusTable.add(this.status);
        main.add(goals).left().row();
        this.statusCell = main.add();
        this.statusCell.row();
        Table reward = new Table();
        reward.defaults().expand().pad(4.0f);
        Label.LabelStyle style = new Label.LabelStyle(QuestWindow.assets.getFont().arial14, Color.WHITE);
        Label expName = new Label((CharSequence)this.model.lang.get("window.quest.exp"), style);
        reward.add(expName).left();
        TextureAtlas atlas = assets.getCommonAtlas();
        Image xpIcon = new Image(atlas.findRegion("xp"));
        reward.add(xpIcon).right().padRight(4.0f);
        style = new Label.LabelStyle(QuestWindow.assets.getFont().arialBold14, Color.CYAN);
        Label exp = new Label((CharSequence)("+" + this.avatarQuest.getQuestType().getRewardExp()), style);
        reward.add(exp).left().row();
        style = new Label.LabelStyle(QuestWindow.assets.getFont().arial14, Color.WHITE);
        Label energyName = new Label((CharSequence)this.model.lang.get("window.quest.energy"), style);
        reward.add(energyName).left();
        Image energyIcon = new Image(atlas.findRegion("energy_icon_small"));
        reward.add(energyIcon).right().padRight(4.0f);
        style = new Label.LabelStyle(QuestWindow.assets.getFont().arialBold14, Color.valueOf("#EFD774"));
        Label energy = new Label((CharSequence)("+" + this.avatarQuest.getQuestType().getRewardEnergy()), style);
        reward.add(energy).left().row();
        style = new Label.LabelStyle(QuestWindow.assets.getFont().arial14, Color.WHITE);
        Label timerName = new Label((CharSequence)this.model.lang.get("window.quest.time_left"), style);
        style = new Label.LabelStyle(QuestWindow.assets.getFont().centryGothicBold25, timeLeft > 0L ? Color.valueOf("#84BD55") : Color.valueOf("#D92121"));
        this.timer = new Label((CharSequence)"00:00", style);
        Table rewardTable = new Table();
        rewardTable.defaults().pad(3.0f);
        rewardTable.add(reward);
        Table timerTable = new Table();
        timerTable.defaults().pad(4.0f);
        timerTable.add(timerName).row();
        timerTable.add(this.timer).expand();
        Table bottom = new Table();
        bottom.add(rewardTable).expandX().left().top().padLeft(20.0f);
        bottom.add(timerTable).expandX().right().padRight(20.0f);
        main.add(bottom).growX();
        this.needUpdateTimer = timeLeft > 0L;
        this.updateTimer();
        this.setStatus();
        this.getButtonTable().padBottom(6.0f);
        TextButton actionButton = new TextButton(this.model.lang.get("window.quest.get_started"), this.getSkin(), "yellow-btn");
        actionButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                long timeLeft = QuestWindow.this.avatarQuest.getLeftTime(QuestWindow.this.model.getServerTime());
                if (QuestWindow.this.avatarQuest.reward) {
                    ((QuestWindow)QuestWindow.this).soundSystem.fx.play("sound/fx/23. Successfull_mine, dig, pryanik.mp3");
                    Commander.getInstance().QuestTakeReward(QuestWindow.this.avatarQuest.id);
                } else if (timeLeft == 0L) {
                    Commander.getInstance().QuestTake(QuestWindow.this.avatarQuest.id);
                }
                QuestWindow.this.closeHandler();
            }
        });
        if (this.avatarQuest.completed && this.avatarQuest.reward) {
            actionButton.setText(this.model.lang.get("window.quest.take_reward"));
            this.getButtonTable().add(actionButton);
        } else if (timeLeft == 0L) {
            actionButton.setText(this.model.lang.get("window.quest.next"));
            this.getButtonTable().add(actionButton);
        } else {
            TextButton skipQuestBtn = new TextButton(this.model.lang.get("window.quest.skip"), QuestWindow.assets.getUi().buyButtonStyle);
            this.getButtonTable().add(skipQuestBtn);
            skipQuestBtn.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (FinanceManager.checkCrystals(((QuestWindow)QuestWindow.this).model.player, FinanceManager.PRICE_SKIP_QUEST)) {
                        FinanceManager.showConfirmWindow(FinanceManager.PRICE_SKIP_QUEST, new ClickListener(){

                            @Override
                            public void clicked(InputEvent event, float x, float y) {
                                WindowManager.getInstance().closeCurrentWindow();
                                Commander.getInstance().SkipQuest(QuestWindow.this.avatarQuest.id);
                                ((QuestWindow)QuestWindow.this).soundSystem.fx.play("sound/fx/28. Buy_crystal.mp3");
                                QuestWindow.this.closeHandler();
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        this.closeHandler();
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.needUpdateTimer) {
            this.timerDelta += delta;
            if (this.timerDelta > 1.0f) {
                this.timerDelta -= 1.0f;
                this.updateTimer();
            }
        }
    }

    private void updateTimer() {
        long timeLeft = this.avatarQuest.getLeftTime(this.model.getServerTime());
        this.timer.setText(TimeUtils.convertTimeHours((int)timeLeft / 1000));
        if (timeLeft == 0L) {
            this.needUpdateTimer = false;
            this.timer.getStyle().fontColor = Color.valueOf("#D92121");
            this.setStatus();
        }
    }

    private void setStatus() {
        if (this.avatarQuest.completed) {
            this.status.getStyle().fontColor = Color.valueOf("#84BD55");
            this.status.setText(this.model.lang.get("window.quest.completed"));
            this.statusCell.setActor(this.statusTable);
        } else if (!this.avatarQuest.isActive()) {
            this.status.setText(this.model.lang.get("window.quest.failed"));
            this.statusCell.setActor(this.statusTable);
        }
    }

    @Override
    public void closeHandler() {
        super.closeHandler();
        this.model.removeListeners(this);
    }

    class GoalWidget
    extends Table {
        public GoalWidget(AvatarQuest avatarQuest, AvatarQuestGoal avatarQuestGoal) {
            String pveInfo;
            TextureAtlas windowAtlas = assets.getWindowAtlas();
            this.setBackground(assets.getNinePatchDrawable(windowAtlas, "content_background", 6, 6, 10, 10));
            TextureAtlas atlas = (TextureAtlas)assets.get("ui/common.atlas");
            int amount = avatarQuestGoal.getQuestGoalType().getAmount();
            boolean completed = avatarQuestGoal.count >= amount;
            Image questMark = new Image(atlas.findRegion(completed ? "missions_mark_complete" : "missions_mark"));
            Label.LabelStyle style = new Label.LabelStyle(assets.getFont().arialBold14, completed ? Color.WHITE : Color.valueOf("#606466"));
            Label num = new Label((CharSequence)(Math.min(avatarQuestGoal.count, amount) + "/" + amount), style);
            VerticalGroup stats = new VerticalGroup();
            stats.addActor(questMark);
            stats.addActor(num);
            this.add(stats).expand().top().pad(10.0f, 10.0f, 0.0f, 20.0f);
            if (avatarQuest.goalUpdated) {
                stats.addAction(Actions.sequence((Action)Actions.delay(0.4f), (Action)Actions.scaleTo(1.2f, 1.2f, 0.2f), (Action)Actions.scaleTo(1.0f, 1.0f, 0.2f)));
            }
            Label.LabelStyle descriptionStyle = new Label.LabelStyle(assets.getFont().arial14, Color.valueOf("#F0E9CF"));
            descriptionStyle.font.getData().markupEnabled = true;
            Label description = new Label((CharSequence)avatarQuestGoal.description(((QuestWindow)QuestWindow.this).model.lang), descriptionStyle);
            description.setWrap(true);
            this.add(description).width(320.0f).row();
            if (avatarQuestGoal.notCompleted() && avatarQuest.isActive() && !StringUtil.isNullOrEmpty(pveInfo = avatarQuestGoal.pveInfo(((QuestWindow)QuestWindow.this).model.lang))) {
                this.add();
                Label.LabelStyle pveStyle = new Label.LabelStyle(assets.getFont().arial12, Color.valueOf("#F0E9CF"));
                pveStyle.font.getData().markupEnabled = true;
                Label pve = new Label((CharSequence)pveInfo, pveStyle);
                pve.setWrap(true);
                this.add(pve).padTop(10.0f).padBottom(5.0f).width(320.0f);
            }
        }
    }
}

