/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.rating;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.rating.RatingLine;
import packet.Rating;

public class ClanRatingLine
extends RatingLine {
    public ClanRatingLine(Assets assets, Rating.ClanRatingDto rating, int pos) {
        super(assets);
        Label.LabelStyle style = new Label.LabelStyle(assets.getFont().arialBold14, Color.WHITE);
        if (pos <= 3) {
            Image ratingCup = new Image(assets.getDrawable(this.atlas, "rating_cup", pos));
            this.add(new Container<Image>(ratingCup)).width(46.0f);
        } else {
            Label position = new Label((CharSequence)String.valueOf(pos), style);
            position.setAlignment(1);
            this.add(position).width(46.0f).center();
        }
        Label name = new Label((CharSequence)String.format("[%s]%s", rating.getTag(), rating.getName()), new Label.LabelStyle(style));
        name.getStyle().fontColor = this.colorForFraction(rating.getFractionId());
        this.add(name).width(200.0f).padLeft(10.0f);
        Label dateTime = new Label((CharSequence)String.valueOf(rating.getRating()), style);
        dateTime.setAlignment(16);
        this.add(dateTime).width(90.0f);
    }
}

