/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.rating;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.rating.RatingLine;
import com.tpwar.storage.Storage;
import com.tpwar.storage.guild.GuildStorage;
import packet.Rating;
import packet.Static;

public class GuildRatingLine
extends RatingLine {
    public GuildRatingLine(Storage storage, Assets assets, Rating.GuildRatingDto rating, int pos) {
        super(assets);
        Label.LabelStyle style = new Label.LabelStyle(assets.getFont().arialBold14, Color.WHITE);
        if (pos <= 3) {
            Image ratingCup = new Image(assets.getDrawable(this.atlas, "rating_cup", pos));
            this.add(new Container<Image>(ratingCup)).width(46.0f);
        } else {
            Label position = new Label((CharSequence)String.valueOf(pos), style);
            position.setAlignment(1);
            this.add(position).width(46.0f).center();
        }
        Label name = new Label((CharSequence)String.format("%s[%d]", rating.getName(), rating.getLevel()), new Label.LabelStyle(style));
        name.getStyle().fontColor = this.colorForFraction(rating.getFractionId());
        this.add(name).width(200.0f).padLeft(10.0f);
        Label dateTime = new Label((CharSequence)String.valueOf(rating.getRating()), style);
        dateTime.setAlignment(16);
        this.add(dateTime).width(58.0f).padRight(2.0f);
        Static.StaticGuild guild = storage.guild.getGuildByTaskId(rating.getTaskTypeId());
        Static.StaticGuildRank rank = storage.guildRanks.getRankByScore(guild.getId(), (int)rating.getRating());
        if (rank != null) {
            Container<Image> guildIconContainer = new Container<Image>(this.guildIcon(assets, rank));
            this.add(guildIconContainer).width(30.0f);
        }
    }

    protected Image guildIcon(Assets assets, Static.StaticGuildRank rank) {
        int frame = GuildStorage.getGuildRankFrame(rank);
        TextureAtlas elements = (TextureAtlas)assets.get("entity/entity_elements.atlas");
        TextureRegion texture = assets.extractRegions(elements, "guild_icon").get(frame);
        texture.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Image image = new Image(texture);
        image.setScale(0.8f);
        return image;
    }
}

