/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.rating;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.rating.ClanRatingLine;
import com.tpwar.game.windows.rating.ExperianceRatinLine;
import com.tpwar.game.windows.rating.GuildRatingLine;
import com.tpwar.game.windows.rating.InvasionRatingLine;
import com.tpwar.game.windows.rating.RatingLine;
import com.tpwar.game.windows.rating.TopAvatarList;
import com.tpwar.net.DataConverter;
import com.tpwar.storage.Storage;
import com.tpwar.storage.guild.TaskTypeData;
import java.util.List;
import packet.Avatars;
import packet.Rating;
import packet.Static;

public class RatingWindow
extends DefaultWindow {
    private final Storage storage = Storage.getInstance();
    private Table rating = new Table();
    private ScrollPane scrollRating;
    private Array<RatingLine> invasionList;
    private Array<RatingLine> expereanceList;
    private Array<RatingLine> clanList;
    private RatingLine currentAvatarRating;
    private Table guildRatingTypeBtns;
    private ButtonGroup<Button> buttons = new ButtonGroup();
    private Array<RatingLine> huntingList;
    private Array<RatingLine> mineList;
    private Array<RatingLine> defenceList;
    private Array<RatingLine> invadeList;
    private Array<RatingLine> devastationList;
    private Array<AvatarData> avatars;
    private ButtonGroup<Button> tabPannel = new ButtonGroup();
    private Table buttonGroup = new Table();
    private Table ratingGroup = new Table();
    private Table fractionRating;
    private Rating.GameRating gameRating;
    private TextureAtlas atlas;
    private TextureAtlas windowAtlas;
    private TextButton.TextButtonStyle btnStyle;
    private Table ratingContainer;
    private boolean isMonthRating = true;
    private RatingType currentType;

    public RatingWindow(Rating.GameRating gameRating) {
        super("Rating");
        this.gameRating = gameRating;
    }

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.rating"));
        this.padRight(6.0f).padBottom(6.0f).padLeft(6.0f);
        this.atlas = (TextureAtlas)assets.get("ui/common.atlas");
        this.btnStyle = new TextButton.TextButtonStyle();
        this.btnStyle.up = assets.getNinePatchDrawable(this.atlas, "rating_btn_up", 6, 6, 2, 2);
        this.btnStyle.checked = assets.getNinePatchDrawable(this.atlas, "rating_btn_down", 6, 6, 2, 2);
        this.btnStyle.font = RatingWindow.assets.getFont().arialBold14;
        this.btnStyle.fontColor = Color.WHITE;
        this.fractionRating = this.fractionRating();
        this.leftSideMenu();
        if (this.gameRating.getPlayersOnline() > 0) {
            this.onlineAvatars();
        }
        this.windowAtlas = (TextureAtlas)assets.get("ui/window.atlas");
        this.rating.defaults().space(4.0f);
        this.scrollRating = new ScrollPane((Actor)this.rating);
        this.ratingContainer = new Table();
        this.ratingContainer.defaults().space(6.0f);
        this.ratingContainer.add(this.scrollRating);
        this.ratingContainer.setBackground(assets.getNinePatchDrawable(this.windowAtlas, "content_background", 4, 4, 4, 4));
        this.ratingContainer.pad(6.0f).top();
        this.ratingGroup.add(this.ratingContainer).grow();
        this.getContentTable().add(this.ratingGroup).height(340.0f).grow().padBottom(6.0f).padTop(6.0f).padRight(6.0f).top();
        this.tabPannel.setChecked(((TextButton)this.tabPannel.getChecked()).getLabel().getText().toString());
        this.setCurrentRating(RatingType.INVASION);
        this.guildRatingTypeBtns = this.guildTypeRatingButton();
    }

    private void onlineAvatars() {
        Label.LabelStyle style = new Label.LabelStyle(RatingWindow.assets.getFont().arialBold14, Color.valueOf("#F0E9CF"));
        Label label = new Label((CharSequence)(this.model.lang.get("window.rating.online") + " " + this.gameRating.getPlayersOnline()), style);
        this.getButtonTable().add(label).expand().pad(4.0f);
    }

    private Rating.FractionRatingDto getFractionRatinf(long fractionId) {
        for (Rating.FractionRatingDto frd : this.gameRating.getFractionRatingListList()) {
            if (frd.getFractionId() != fractionId) continue;
            return frd;
        }
        return null;
    }

    private Table fractionRating() {
        Static.StaticFaction wayland = this.storage.faction.getWayland();
        Static.StaticFaction oseon = this.storage.faction.getOseon();
        Rating.FractionRatingDto waylandRatingData = this.getFractionRatinf(wayland.getId());
        Rating.FractionRatingDto oseonRatingData = this.getFractionRatinf(oseon.getId());
        int waylandRatingNum = waylandRatingData != null ? waylandRatingData.getRating() : 0;
        int oseonRatingNum = oseonRatingData != null ? oseonRatingData.getRating() : 0;
        Table table = new Table();
        VerticalGroup walandWidget = new VerticalGroup();
        walandWidget.space(4.0f);
        Color waylandColor = Color.valueOf(this.storage.faction.getColor(wayland.getId()));
        Label.LabelStyle styleWayland = new Label.LabelStyle(RatingWindow.assets.getFont().arialBold14, waylandColor);
        Label waylandName = new Label((CharSequence)wayland.getName(), styleWayland);
        walandWidget.addActor(waylandName);
        Label.LabelStyle styleNum = new Label.LabelStyle(RatingWindow.assets.getFont().arialBold14, Color.WHITE);
        Label waylandRating = new Label((CharSequence)String.valueOf(waylandRatingNum), styleNum);
        walandWidget.addActor(waylandRating);
        VerticalGroup oseonWidget = new VerticalGroup();
        oseonWidget.space(4.0f);
        Color oseonColor = Color.valueOf(this.storage.faction.getColor(oseon.getId()));
        Label.LabelStyle styleOseon = new Label.LabelStyle(RatingWindow.assets.getFont().arialBold14, oseonColor);
        Label oseonName = new Label((CharSequence)oseon.getName(), styleOseon);
        oseonWidget.addActor(oseonName);
        Label oseonRating = new Label((CharSequence)String.valueOf(oseonRatingNum), styleNum);
        oseonWidget.addActor(oseonRating);
        String text = this.model.lang.get("window.rating.description.default");
        if (waylandRatingNum > oseonRatingNum) {
            text = this.model.lang.format("window.rating.description.fraction", wayland.getName());
        } else if (waylandRatingNum < oseonRatingNum) {
            text = this.model.lang.format("window.rating.description.fraction", oseon.getName());
        }
        Label.LabelStyle style = new Label.LabelStyle(RatingWindow.assets.getFont().arial16, Color.WHITE);
        Label label = new Label((CharSequence)text, style);
        table.add(walandWidget).expand();
        table.add(label).space(20.0f).center();
        table.add(oseonWidget);
        return table;
    }

    private Table guildTypeRatingButton() {
        HorizontalGroup btns = new HorizontalGroup();
        TextButton.TextButtonStyle leftBtnStyle = new TextButton.TextButtonStyle();
        leftBtnStyle.checked = assets.getNinePatchDrawable(this.windowAtlas, "green_radio_btn_on", 4, 0, 0, 0);
        leftBtnStyle.up = assets.getNinePatchDrawable(this.windowAtlas, "green_radio_btn_off", 4, 0, 0, 0);
        leftBtnStyle.font = RatingWindow.assets.getFont().arialBold14;
        leftBtnStyle.checkedFontColor = Color.WHITE;
        leftBtnStyle.up.setMinWidth(100.0f);
        TextButton monthTypeBtn = new TextButton("\u041c\u0435\u0441\u044f\u0447\u043d\u044b\u0439", leftBtnStyle);
        monthTypeBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                RatingWindow.this.isMonthRating = true;
                RatingWindow.this.setCurrentRating(RatingWindow.this.currentType);
            }
        });
        this.buttons.add(monthTypeBtn);
        btns.addActor(monthTypeBtn);
        TextButton.TextButtonStyle rightBtnStyle = new TextButton.TextButtonStyle(leftBtnStyle);
        rightBtnStyle.checked = assets.getNinePatchDrawable(this.windowAtlas, "green_right_radio_btn_on", 0, 4, 0, 0);
        rightBtnStyle.up = assets.getNinePatchDrawable(this.windowAtlas, "green_right_radio_btn_off", 0, 4, 0, 0);
        rightBtnStyle.up.setMinWidth(100.0f);
        TextButton allTypeBtn = new TextButton("\u0412\u0441\u0435 \u0432\u0440\u0435\u043c\u044f", rightBtnStyle);
        allTypeBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                RatingWindow.this.isMonthRating = false;
                RatingWindow.this.setCurrentRating(RatingWindow.this.currentType);
            }
        });
        this.buttons.add(allTypeBtn);
        btns.addActor(allTypeBtn);
        Table table = new Table();
        table.add(btns).expand();
        return table;
    }

    private TextButton.TextButtonStyle buttonStyle(TextureAtlas atlas) {
        TextButton.TextButtonStyle btnStyle = new TextButton.TextButtonStyle();
        btnStyle.checked = assets.getNinePatchDrawable(atlas, "max_btn_down", 6, 6, 1, 1);
        btnStyle.up = assets.getNinePatchDrawable(atlas, "max_btn_up", 6, 6, 1, 1);
        btnStyle.font = RatingWindow.assets.getFont().arialBold14;
        btnStyle.fontColor = Color.valueOf("#EFD774");
        return btnStyle;
    }

    private void invasionRating() {
        this.invasionList = new Array(20);
        for (int i = 0; i < this.gameRating.getAvatarInvasionListCount(); ++i) {
            Rating.AvatarInvasionDto rating = this.gameRating.getAvatarInvasionList(i);
            this.invasionList.add(new InvasionRatingLine(assets, rating, i + 1));
        }
    }

    private void experienceRating() {
        this.expereanceList = new Array(20);
        for (int i = 0; i < this.gameRating.getAvatarRatingListCount(); ++i) {
            Rating.AvatarRatingDto rating = this.gameRating.getAvatarRatingList(i);
            if (rating.getRank() > 0) {
                this.currentAvatarRating = new ExperianceRatinLine(assets, rating.getName(), rating.getLevel(), rating.getFractionId(), (int)rating.getRating(), rating.getRank());
                continue;
            }
            this.expereanceList.add(new ExperianceRatinLine(assets, rating.getName(), rating.getLevel(), rating.getFractionId(), (int)rating.getRating(), i + 1));
        }
    }

    private void clanRating() {
        this.clanList = new Array(20);
        for (int i = 0; i < this.gameRating.getClanRatingListCount(); ++i) {
            Rating.ClanRatingDto rating = this.gameRating.getClanRatingList(i);
            this.clanList.add(new ClanRatingLine(assets, rating, i + 1));
        }
    }

    private Array<RatingLine> guildRating(List<Rating.GuildRatingDto> ratingList, String taskTypeCode) {
        TaskTypeData taskType = this.storage.taskType.getByCode(taskTypeCode);
        Array<RatingLine> lines = new Array<RatingLine>(20);
        int pos = 1;
        for (int i = 0; i < ratingList.size(); ++i) {
            Rating.GuildRatingDto rating = ratingList.get(i);
            if (rating.getTaskTypeId() != taskType.data.getId()) continue;
            lines.add(new GuildRatingLine(this.storage, assets, rating, pos++));
        }
        return lines;
    }

    private Array<RatingLine> guildMonthRating(List<Rating.AvatarTaskRatingDto> ratingList, String taskTypeCode) {
        TaskTypeData taskType = this.storage.taskType.getByCode(taskTypeCode);
        Array<RatingLine> lines = new Array<RatingLine>(20);
        int pos = 1;
        for (int i = 0; i < ratingList.size(); ++i) {
            Rating.AvatarTaskRatingDto rating = ratingList.get(i);
            if (rating.getTaskTypeId() != taskType.data.getId()) continue;
            lines.add(new ExperianceRatinLine(assets, rating.getName(), rating.getLevel(), rating.getFractionId(), (int)rating.getRating(), pos++));
        }
        return lines;
    }

    private void leftSideMenu() {
        this.menuButton("window.rating.btn.invasion", 6, true, RatingType.INVASION);
        this.menuButton("window.rating.btn.experiance", 6, true, RatingType.EXPERIENCE);
        this.menuButton("window.rating.btn.clan", 14, true, RatingType.CLAN);
        this.menuButton("window.rating.btn.hunting", 6, true, RatingType.HUNTING);
        this.menuButton("window.rating.btn.mine", 6, true, RatingType.MINE);
        this.menuButton("window.rating.btn.defense", 6, true, RatingType.DEFENCE);
        this.menuButton("window.rating.btn.invade", 6, true, RatingType.INVADE);
        this.menuButton("window.rating.btn.devastation", 14, true, RatingType.DEVASTATION);
        this.menuButton("window.rating.btn.avatars", 6, false, RatingType.AVATARS);
        this.getContentTable().add(this.buttonGroup).width(130.0f).top().left().padLeft(10.0f).padRight(10.0f).padBottom(20.0f).padTop(10.0f);
    }

    private Button menuButton(String nameKey, int padBottom, boolean isCheckbox, final RatingType type) {
        TextButton.TextButtonStyle s = this.btnStyle;
        if (!isCheckbox) {
            s = new TextButton.TextButtonStyle(this.btnStyle);
            s.down = s.checked;
            s.checked = null;
        }
        TextButton textButton = new TextButton(this.model.lang.get(nameKey), s);
        textButton.addListener(new ClickListener(){
            final RatingType btnType;
            {
                this.btnType = type;
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                RatingWindow.this.setCurrentRating(this.btnType);
            }
        });
        if (isCheckbox) {
            this.tabPannel.add(textButton);
        }
        this.buttonGroup.add(textButton).padBottom(padBottom).fillX().row();
        return textButton;
    }

    private void showRating(Array<RatingLine> list) {
        this.rating.clear();
        for (RatingLine rl : list) {
            this.rating.add(rl).expand().row();
        }
        this.ratingContainer.clear();
        this.ratingContainer.add(this.scrollRating);
    }

    private void setCurrentRating(RatingType type) {
        if (type == null) {
            return;
        }
        if (type != RatingType.AVATARS) {
            this.currentType = type;
        }
        if (this.currentAvatarRating != null) {
            this.currentAvatarRating.remove();
        }
        switch (type) {
            case EXPERIENCE: {
                if (this.expereanceList == null) {
                    this.experienceRating();
                }
                this.showRating(this.expereanceList);
                if (this.currentAvatarRating == null) break;
                this.ratingContainer.row();
                this.ratingContainer.add(this.currentAvatarRating);
                break;
            }
            case INVASION: {
                if (this.invasionList == null) {
                    this.invasionRating();
                }
                this.showRating(this.invasionList);
                this.ratingContainer.clear();
                this.ratingContainer.add(this.fractionRating).padBottom(4.0f).row();
                this.ratingContainer.add(this.scrollRating);
                break;
            }
            case CLAN: {
                if (this.clanList == null) {
                    this.clanRating();
                }
                this.showRating(this.clanList);
                break;
            }
            case HUNTING: {
                this.huntingList = this.isMonthRating ? this.guildMonthRating(this.gameRating.getAvatarTaskRatingListList(), "hunting") : this.guildRating(this.gameRating.getGuildRatingListList(), "hunting");
                this.showRating(this.huntingList);
                this.ratingContainer.clear();
                this.ratingContainer.add(this.guildRatingTypeBtns).padBottom(4.0f).row();
                this.ratingContainer.add(this.scrollRating);
                break;
            }
            case MINE: {
                this.mineList = this.isMonthRating ? this.guildMonthRating(this.gameRating.getAvatarTaskRatingListList(), "mine") : this.guildRating(this.gameRating.getGuildRatingListList(), "mine");
                this.showRating(this.mineList);
                this.ratingContainer.clear();
                this.ratingContainer.add(this.guildRatingTypeBtns).padBottom(4.0f).row();
                this.ratingContainer.add(this.scrollRating);
                break;
            }
            case DEFENCE: {
                this.defenceList = this.isMonthRating ? this.guildMonthRating(this.gameRating.getAvatarTaskRatingListList(), "defense") : this.guildRating(this.gameRating.getGuildRatingListList(), "defense");
                this.showRating(this.defenceList);
                this.ratingContainer.clear();
                this.ratingContainer.add(this.guildRatingTypeBtns).padBottom(4.0f).row();
                this.ratingContainer.add(this.scrollRating);
                break;
            }
            case INVADE: {
                this.invadeList = this.isMonthRating ? this.guildMonthRating(this.gameRating.getAvatarTaskRatingListList(), "invade") : this.guildRating(this.gameRating.getGuildRatingListList(), "invade");
                this.showRating(this.invadeList);
                this.ratingContainer.clear();
                this.ratingContainer.add(this.guildRatingTypeBtns).padBottom(4.0f).row();
                this.ratingContainer.add(this.scrollRating);
                break;
            }
            case DEVASTATION: {
                this.devastationList = this.isMonthRating ? this.guildMonthRating(this.gameRating.getAvatarTaskRatingListList(), "devastation") : this.guildRating(this.gameRating.getGuildRatingListList(), "devastation");
                this.showRating(this.devastationList);
                this.ratingContainer.clear();
                this.ratingContainer.add(this.guildRatingTypeBtns).padBottom(4.0f).row();
                this.ratingContainer.add(this.scrollRating);
                break;
            }
            case AVATARS: {
                if (this.avatars == null) {
                    this.avatars = new Array(10);
                    for (Avatars.AvatarDto avatarDto : this.gameRating.getAvatarsList()) {
                        this.avatars.add(DataConverter.fromAvatarDto(avatarDto));
                    }
                }
                WindowManager.getInstance().open(new TopAvatarList(this.avatars), true);
                break;
            }
        }
    }

    static enum RatingType {
        INVASION,
        EXPERIENCE,
        CLAN,
        HUNTING,
        MINE,
        DEFENCE,
        INVADE,
        DEVASTATION,
        AVATARS;

    }
}

