/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.rating;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.action.AvatarSlotWithButton;

public class TopAvatarList
extends DefaultWindow {
    private Model model = Model.getInstance();
    private ScrollPane scrollPane;
    private Table content;
    private Array<AvatarData> avatars;

    public TopAvatarList(Array<AvatarData> avatars) {
        super("");
        this.avatars = avatars;
    }

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.rating.btn.avatars"));
        Table main = new Table();
        this.getContentTable().add(main).expand().left().pad(10.0f, 20.0f, 10.0f, 20.0f).top();
        this.content = new Table();
        this.content.align(8);
        this.addActor(this.content);
        for (AvatarData avatar : this.avatars) {
            AvatarSlotWithButton as = new AvatarSlotWithButton(avatar, true);
            this.content.add(as).width(160.0f).padLeft(10.0f).left();
        }
        this.scrollPane = new ScrollPane((Actor)this.content);
        this.scrollPane.layout();
        Table container = new Table();
        container.add(this.scrollPane).size(640.0f, 300.0f).expand().top();
        main.add(container).grow().left().top();
    }

    @Override
    public void closeHandler() {
        super.closeHandler();
    }
}

