/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.tutorial;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.domain.Model;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.GameWindow;

public class TutorialWindow
extends GameWindow {
    private TextButton closeButton;

    public TutorialWindow(Skin skin, String text) {
        super("", skin, "tutorial");
        Assets assets = Assets.getInstance();
        Label.LabelStyle fieldStyle = new Label.LabelStyle(assets.getFont().arial16, Color.WHITE);
        Label textLabel = new Label((CharSequence)text, fieldStyle);
        textLabel.setAlignment(1);
        this.getContentTable().add(textLabel).pad(10.0f).padBottom(16.0f);
        this.closeButton = new TextButton(Model.getInstance().lang.get("window.confirm.ok"), this.getSkin(), "yellow-btn");
        this.closeButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                TutorialWindow.this.closeHandler();
            }
        });
        this.getButtonTable().add(this.closeButton);
        this.setModal(true);
    }

    @Override
    public void openHandler() {
    }

    @Override
    public void closeHandler() {
        this.setModal(false);
        super.closeHandler();
    }

    public TextButton getCloseButton() {
        return this.closeButton;
    }
}

