/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.unit;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.UnitData;
import com.tpwar.game.utils.Assets;
import com.tpwar.net.Commander;
import com.tpwar.storage.Storage;
import com.tpwar.storage.planet.PlanetData;
import com.tpwar.storage.unit.UnitTypeData;
import packet.Static;

public class UnitSlot
extends Table {
    private final Assets assets = Assets.getInstance();
    private final Model model = Model.getInstance();
    private final Storage storage = Storage.getInstance();
    private final Commander commander = Commander.getInstance();
    private UnitData unit;
    private Label progress;

    public UnitSlot() {
        this.defaults().space(10.0f);
    }

    public void setUnit(final UnitData unit) {
        if (unit == null) {
            return;
        }
        if (this.hasUnit()) {
            this.unit = unit;
            return;
        }
        this.unit = unit;
        Label.LabelStyle style = new Label.LabelStyle(this.assets.getFont().arialBold16, Color.valueOf("#EFD774"));
        Label name = new Label((CharSequence)unit.getType().name, style);
        name.setAlignment(1);
        this.add(name).top().growX().padBottom(6.0f).row();
        UnitTypeData unitTypeData = this.storage.unitType.get(unit.unitTypeId);
        Container<Image> back = new Container<Image>(new Image(this.assets.getCommonAtlas().findRegion("unit_slot")));
        back.padBottom(30.0f);
        Container<Image> icon = new Container<Image>(this.unitIcon(unitTypeData));
        icon.padBottom(31.0f);
        TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/barrack.atlas");
        Container<Image> fade = new Container<Image>(new Image(atlas.findRegion("slot_fade")));
        fade.padBottom(30.0f);
        Table progressTable = new Table();
        progressTable.setBackground(this.assets.getNinePatchDrawable(atlas, "unit_bottom_slot", 2, 2, 2, 2));
        this.progress = new Label((CharSequence)"", style);
        this.progress.setAlignment(1);
        progressTable.add(this.progress).bottom().width(86.0f).padBottom(0.0f).padTop(32.0f);
        Container<Table> progressContainer = new Container<Table>(progressTable);
        progressContainer.align(4);
        this.stack(progressContainer, back, icon, fade).expand().padBottom(6.0f).row();
        AvatarData avatar = this.model.player.selectedAvatar;
        PlanetData planet = this.storage.planet.get(avatar.planetId);
        Static.StaticFaction faction = this.storage.faction.get(avatar.fractionId);
        if (this.storage.planet.isHomePlanet(planet) && faction.getId() == avatar.fractionId) {
            TextButton removeBtn = new TextButton(this.model.lang.get("window.units.expel"), this.assets.getUi().redButtonStyle);
            this.add(removeBtn).expand().row();
            removeBtn.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    UnitSlot.this.commander.RemoveUnit(unit.id);
                }
            });
        }
        this.add(this.parametersTable(unit)).grow();
    }

    private Table parametersTable(UnitData unit) {
        TextureAtlas atlas = (TextureAtlas)this.assets.get("units/battle_elements.atlas");
        Table table = new Table();
        table.pad(6.0f).padLeft(10.0f).padRight(10.0f);
        table.defaults().expand().space(6.0f);
        table.setBackground(new NinePatchDrawable(this.assets.getNinePatchDrawable(atlas, "parameters_bg", 3, 3, 3, 3)));
        Label.LabelStyle styleName = new Label.LabelStyle(this.assets.getFont().arial14, Color.WHITE);
        Label.LabelStyle style = new Label.LabelStyle(this.assets.getFont().arialBold14, Color.WHITE);
        table.add(new Image(this.assets.getDrawable(atlas, "damage_icon")));
        Label nameDamage = new Label((CharSequence)this.model.lang.get("window.barrack.damage"), styleName);
        table.add(nameDamage).left();
        Label damage = new Label((CharSequence)String.valueOf(unit.getType().fullDamage), style);
        damage.setAlignment(16);
        table.add(damage).row();
        table.add(new Image(this.assets.getDrawable(atlas, "armor_icon")));
        Label nameArmor = new Label((CharSequence)this.model.lang.get("window.barrack.armor"), styleName);
        table.add(nameArmor).left();
        Label armor = new Label((CharSequence)String.valueOf(unit.getType().fullArmor), style);
        armor.setAlignment(16);
        table.add(armor).row();
        table.add(new Image(this.assets.getDrawable(atlas, "health_icon")));
        Label nameHealth = new Label((CharSequence)this.model.lang.get("window.barrack.health"), styleName);
        table.add(nameHealth).left();
        Label health = new Label((CharSequence)String.valueOf(unit.getType().fullHealth), style);
        health.setAlignment(16);
        table.add(health);
        return table;
    }

    public void setProgressText(String progress) {
        this.progress.setText(progress);
    }

    private Image unitIcon(UnitTypeData unitTypeData) {
        String unitIconName = "unit_icon%s0001";
        switch (unitTypeData.code) {
            case "farn": {
                unitIconName = "unit_icon%s0002";
                break;
            }
            case "havy": {
                unitIconName = "unit_icon%s0003";
            }
        }
        TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/barrack.atlas");
        AvatarData avatar = this.model.player.selectedAvatar;
        return new Image(atlas.findRegion(String.format(unitIconName, avatar.fractionId == 1L ? "_oseon" : "")));
    }

    public boolean hasUnit() {
        return this.unit != null;
    }

    public UnitData getUnit() {
        return this.unit;
    }

    public void empty() {
        this.clear();
        TextureAtlas atlas = (TextureAtlas)this.assets.get("units/battle_elements.atlas");
        this.setBackground(new NinePatchDrawable(this.assets.getNinePatchDrawable(atlas, "parameters_bg", 3, 3, 3, 3)));
        Label.LabelStyle style = new Label.LabelStyle(this.assets.getFont().arialBold14, Color.WHITE);
        Label emptySlot = new Label((CharSequence)this.model.lang.get("window.units.empty"), style);
        this.add(emptySlot).fill();
    }
}

