/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.unit;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Timer;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.TimeWarpData;
import com.tpwar.domain.avatar.UnitData;
import com.tpwar.game.managers.UnitManager;
import com.tpwar.game.utils.StringUtils;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.unit.UnitSlot;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import packet.Transport;

public class UnitsWindow
extends DefaultWindow
implements MessageListener {
    private Array<UnitSlot> slots;
    private TimeWarpData timeWarp;
    private UnitData currentUnit;
    private Table main;
    private Timer.Task task;

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.units"));
        this.padBottom(0.0f);
        this.slots = new Array(3);
        this.main = new Table();
        this.main.pad(10.0f, 20.0f, 10.0f, 20.0f);
        this.main.defaults().space(30.0f);
        this.getContentTable().add(this.main);
        for (int i = 0; i < 3; ++i) {
            UnitSlot slot = new UnitSlot();
            slot.pack();
            this.slots.add(slot);
        }
        AvatarData avatar = this.model.player.selectedAvatar;
        this.timeWarp = avatar.getActiveTimeWarp();
        this.task = Timer.schedule(new Timer.Task(){

            @Override
            public void run() {
                UnitsWindow.this.onTimer();
            }
        }, 0.0f, 1.0f);
        if (avatar.getNumUnits() < 3) {
            TextButton buyUnits = new TextButton(this.model.lang.get("window.barrack.buy_now"), UnitsWindow.assets.getUi().buyButtonStyle);
            buyUnits.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    UnitsWindow.this.closeHandler();
                    UnitManager.buyUnits();
                }
            });
            this.getButtonTable().add(buyUnits);
            this.getButtonTable().padBottom(6.0f);
        }
        this.storage.unitType.calcFullParameters(avatar);
        this.update();
        this.model.addListener(this, Cmd.UpdateUnits.getCode());
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        this.update();
    }

    public void update() {
        AvatarData avatar = this.model.player.selectedAvatar;
        Array<UnitData> units = avatar.units;
        boolean armyIsCompleted = avatar.getNumUnits() == 3;
        this.main.clear();
        this.currentUnit = null;
        for (int i = 0; i < 3; ++i) {
            UnitSlot slot = this.slots.get(i);
            UnitData unitData = this.findUnitBySlot(i + 1);
            if (unitData != null) {
                slot.setUnit(unitData);
            } else {
                slot.empty();
            }
            this.main.add(slot).minSize(130.0f, 286.0f).fillY();
            if (this.currentUnit != null || i >= units.size || units.get((int)i).isCreated) continue;
            this.currentUnit = units.get(i);
        }
        if (armyIsCompleted) {
            this.task.cancel();
            this.onTimer();
        }
    }

    private void onTimer() {
        boolean hasUnitInProcess = false;
        long lastTime = 0L;
        for (int i = 0; i < 3; ++i) {
            boolean applyScale;
            UnitSlot slot = this.slots.get(i);
            if (!slot.hasUnit()) continue;
            UnitData unit = slot.getUnit();
            if (unit.isCreated) {
                slot.setProgressText("100 %");
            } else {
                slot.setProgressText("00 %");
            }
            if (hasUnitInProcess) {
                slot.setProgressText("00 %");
                continue;
            }
            long unitStartTimeMillis = unit.startTime;
            long activationTimeMillis = this.timeWarp != null ? this.timeWarp.activationTime : Long.MAX_VALUE;
            boolean bl = applyScale = Math.max(lastTime, unitStartTimeMillis) >= activationTimeMillis;
            long timeout = applyScale ? (long)unit.getType().getTimeoutWithScale(this.timeWarp != null ? this.timeWarp.getType().getSacle() : 0).intValue() : (long)unit.getType().timeout;
            float leftTime = unit.getLeftTime(timeout);
            float totalTime = timeout * 1000L;
            if (unit == this.currentUnit && leftTime >= 0.0f) {
                if (leftTime == 0.0f) {
                    leftTime = 1.0f;
                }
                slot.setProgressText(StringUtils.convertToPercent(leftTime, totalTime));
                hasUnitInProcess = true;
            }
            lastTime = unitStartTimeMillis + timeout * 1000L;
        }
    }

    private UnitData findUnitBySlot(int slot) {
        AvatarData avatar = this.model.player.selectedAvatar;
        for (UnitData unit : avatar.units) {
            if (unit.slot != slot) continue;
            return unit;
        }
        return null;
    }

    @Override
    public void closeHandler() {
        this.task.cancel();
        this.model.removeListeners(this);
        super.closeHandler();
    }
}

