/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.warning;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.domain.Model;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.Component;
import com.tpwar.game.windows.DefaultWindow;

public class WarningWindow
extends DefaultWindow {
    private final Assets assets = Assets.getInstance();
    private TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/common.atlas");
    private Image icon;
    private TextButton actionButton;
    private Label textLabel;
    private Type type;
    private String title;
    private String message;
    private String answer;
    private ClickListener listener;

    public WarningWindow(Type type, String title, String message, String answer) {
        this(type, title, message, answer, null);
    }

    public WarningWindow(Type type, String title, String message, String answer, ClickListener listener) {
        super(400, 240);
        this.type = type;
        this.title = title;
        this.message = message;
        this.answer = answer;
        this.listener = listener;
    }

    public static WarningWindow create(Type type, String titleKey, String messageKey, String answerKey) {
        Model model = Model.getInstance();
        String title = model.lang.get(titleKey);
        String message = model.lang.get(messageKey);
        String answer = model.lang.get(answerKey);
        return new WarningWindow(type, title, message, answer);
    }

    @Deprecated
    public WarningWindow setActionlistener(ClickListener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public void openHandler() {
        this.setTitle(this.title);
        switch (this.type) {
            case INFO: {
                this.icon = Component.getImage(this.atlas, "warning_icon0003");
                break;
            }
            case ERROR: {
                this.icon = Component.getImage(this.atlas, "warning_icon0002");
                break;
            }
            case WARNING: {
                this.icon = Component.getImage(this.atlas, "warning_icon0001");
            }
        }
        this.getContentTable().add(this.icon).expand().pad(10.0f);
        Label.LabelStyle fieldStyle = new Label.LabelStyle(this.assets.getFont().arial16, Color.WHITE);
        this.assets.getFont().arial16.getData().markupEnabled = true;
        this.textLabel = new Label((CharSequence)this.message, fieldStyle);
        this.textLabel.setWrap(true);
        this.getContentTable().add(this.textLabel).width(260.0f).padRight(10.0f);
        this.actionButton = new TextButton(this.answer, this.getSkin(), "yellow-btn");
        this.actionButton.getLabel().setTouchable(Touchable.disabled);
        this.getButtonTable().add(this.actionButton);
        this.getButtonTable().padBottom(6.0f);
        if (this.listener != null) {
            this.actionButton.addListener(this.listener);
        } else {
            this.actionButton.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    WarningWindow.this.closeHandler();
                }
            });
        }
    }

    public TextButton getActionButton() {
        return this.actionButton;
    }

    public static enum Type {
        INFO,
        WARNING,
        ERROR;

    }
}

