/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.workshop;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageTextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.utils.Scaling;

public class WorkshopImageButton
extends Button {
    private final Image image;
    private Label label;
    private ImageTextButton.ImageTextButtonStyle style;

    public WorkshopImageButton(String text, ImageTextButton.ImageTextButtonStyle style) {
        super(style);
        this.style = style;
        this.defaults().space(3.0f);
        this.image = new Image(style.imageUp);
        this.image.setScaling(Scaling.fit);
        this.label = new Label((CharSequence)text, new Label.LabelStyle(style.font, style.fontColor));
        this.label.setAlignment(1);
        this.add(this.label).expandX();
        this.add(this.image).padRight(4.0f).padBottom(2.0f);
        this.setStyle(style);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Color fontColor = this.isDisabled() && this.style.disabledFontColor != null ? this.style.disabledFontColor : (this.isPressed() && this.style.downFontColor != null ? this.style.downFontColor : (this.isChecked() && this.style.checkedFontColor != null ? (this.isOver() && this.style.checkedOverFontColor != null ? this.style.checkedOverFontColor : this.style.checkedFontColor) : (this.isOver() && this.style.overFontColor != null ? this.style.overFontColor : this.style.fontColor)));
        if (fontColor != null) {
            this.label.getStyle().fontColor = fontColor;
        }
        super.draw(batch, parentAlpha);
    }
}

