/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.workshop;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.ImageTextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.workshop.WorkshopImageButton;
import com.tpwar.game.windows.workshop.artefact.WorkshopArtefactPanel;
import com.tpwar.game.windows.workshop.other.WorkshopOtherPanel;
import com.tpwar.game.windows.workshop.tech.WorkshopTechPanel;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import packet.Transport;

public class WorkshopWindow
extends DefaultWindow
implements MessageListener {
    private WorkshopTechPanel techPanel;
    private WorkshopArtefactPanel artefactPanel;
    private Table main;
    private Table rightSide;
    private WorkshopOtherPanel otherPanel;

    public WorkshopWindow() {
        super("");
    }

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.workshop"));
        this.main = new Table();
        this.main.defaults().space(20.0f);
        this.getContentTable().add(this.main).expand().pad(10.0f, 20.0f, 10.0f, 20.0f);
        this.main.add(this.menu()).growY();
        this.rightSide = new Table();
        this.main.add(this.rightSide).expand();
        this.techPanel = new WorkshopTechPanel();
        this.setTechPanel(0);
        this.artefactPanel = new WorkshopArtefactPanel();
        this.otherPanel = new WorkshopOtherPanel();
        this.model.addListener(this, Cmd.ArtefactPurchased.getCode());
        this.model.addListener(this, Cmd.ArtefactUpdate.getCode());
        this.model.addListener(this, Cmd.AvatarUpdate.getCode());
        this.model.addListener(this, Cmd.UnitTechUpdate.getCode());
        this.model.addListener(this, Cmd.UnitTechPurchased.getCode());
    }

    private VerticalGroup menu() {
        TextureAtlas windowAtlas = assets.getWindowAtlas();
        TextureAtlas workshopAtlas = (TextureAtlas)assets.get("ui/workshop.atlas");
        ImageTextButton.ImageTextButtonStyle gtitb = new ImageTextButton.ImageTextButtonStyle();
        gtitb.up = assets.getNinePatchDrawable(windowAtlas, "gray_tab_btn_up", 4, 4, 4, 4);
        gtitb.over = assets.getNinePatchDrawable(windowAtlas, "gray_tab_btn_over", 4, 4, 4, 4);
        gtitb.checked = assets.getNinePatchDrawable(windowAtlas, "gray_tab_btn_down", 4, 4, 4, 4);
        gtitb.disabled = assets.getNinePatchDrawable(windowAtlas, "gray_tab_btn_disable", 4, 4, 4, 4);
        gtitb.imageUp = assets.getDrawable(workshopAtlas, "damage_btn_icon");
        gtitb.font = WorkshopWindow.assets.getFont().arialBold14;
        ButtonGroup<Button> tabPannel = new ButtonGroup<Button>();
        VerticalGroup buttonGroup = new VerticalGroup();
        buttonGroup.space(10.0f);
        WorkshopImageButton damageTech = new WorkshopImageButton(this.model.lang.get("window.workshop.tech.damage"), gtitb);
        damageTech.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                WorkshopWindow.this.setTechPanel(0);
            }
        });
        tabPannel.add(damageTech);
        buttonGroup.addActor(damageTech);
        gtitb = new ImageTextButton.ImageTextButtonStyle(gtitb);
        gtitb.imageUp = assets.getDrawable(workshopAtlas, "armor_btn_icon");
        WorkshopImageButton armorTech = new WorkshopImageButton(this.model.lang.get("window.workshop.tech.armor"), gtitb);
        armorTech.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                WorkshopWindow.this.setTechPanel(1);
            }
        });
        tabPannel.add(armorTech);
        buttonGroup.addActor(armorTech);
        gtitb = new ImageTextButton.ImageTextButtonStyle(gtitb);
        gtitb.imageUp = assets.getDrawable(workshopAtlas, "health_btn_icon");
        WorkshopImageButton healthTech = new WorkshopImageButton(this.model.lang.get("window.workshop.tech.health"), gtitb);
        healthTech.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                WorkshopWindow.this.setTechPanel(2);
            }
        });
        tabPannel.add(healthTech);
        buttonGroup.addActor(healthTech);
        gtitb = new ImageTextButton.ImageTextButtonStyle(gtitb);
        gtitb.imageUp = assets.getDrawable(workshopAtlas, "artefacts_btn_icon");
        WorkshopImageButton artefacts = new WorkshopImageButton(this.model.lang.get("window.workshop.artefacts"), gtitb);
        artefacts.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                WorkshopWindow.this.setArtefactPanel();
            }
        });
        tabPannel.add(artefacts);
        buttonGroup.addActor(artefacts);
        gtitb = new ImageTextButton.ImageTextButtonStyle(gtitb);
        TextButton other = new TextButton(this.model.lang.get("window.workshop.other"), gtitb);
        other.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                WorkshopWindow.this.setOtherPanel();
            }
        });
        tabPannel.add(other);
        buttonGroup.addActor(other);
        return buttonGroup;
    }

    private void setTechPanel(int parameterType) {
        this.rightSide.clear();
        this.techPanel.setParameterType(parameterType);
        this.rightSide.add(this.techPanel).expand();
    }

    private void setArtefactPanel() {
        this.rightSide.clear();
        this.rightSide.add(this.artefactPanel).expand();
    }

    private void setOtherPanel() {
        this.rightSide.clear();
        this.rightSide.add(this.otherPanel).expand();
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        Cmd cmd = Cmd.Enums.byInt(code);
        switch (cmd) {
            case ArtefactPurchased: 
            case AvatarUpdate: 
            case ArtefactUpdate: {
                this.artefactPanel.update();
                break;
            }
            case UnitTechPurchased: 
            case UnitTechUpdate: {
                this.techPanel.update();
                break;
            }
        }
    }

    @Override
    public void closeHandler() {
        this.model.removeListeners(this);
        super.closeHandler();
    }
}

