/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.workshop.artefact;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.managers.FinanceManager;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.net.Commander;
import com.tpwar.sound.SoundSystem;
import com.tpwar.storage.avatar.ArtefactType;

public class WorkshopArtefactItem
extends Table {
    private final Assets assets = Assets.getInstance();
    private final Model model = Model.getInstance();
    private final SoundSystem soundSystem = SoundSystem.getInstance();
    private final WindowManager windowManager = WindowManager.getInstance();
    private final TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/workshop.atlas");

    public WorkshopArtefactItem(final ArtefactType artefactType) {
        Label name = new Label((CharSequence)artefactType.name, new Label.LabelStyle(this.assets.getFont().arialBold14, Color.valueOf("#95DEFF")));
        Table content = new Table();
        Image techImage = new Image(this.atlas.findRegion(WorkshopArtefactItem.getImageKey(artefactType)));
        Label value = new Label((CharSequence)"x5", new Label.LabelStyle(this.assets.getFont().arialBold16, Color.valueOf("#FFCC4F")));
        Table vTable = new Table();
        vTable.defaults().space(6.0f);
        vTable.add(value).expandY();
        vTable.add(techImage);
        Table tTable = new Table();
        TextureAtlas.AtlasRegion texhImageBgRegion = this.atlas.findRegion(WorkshopArtefactItem.getImageKey(artefactType));
        texhImageBgRegion.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Image imageBg = new Image(texhImageBgRegion);
        imageBg.setScale(4.0f);
        imageBg.setColor(Color.WHITE.cpy());
        imageBg.getColor().a = 0.09f;
        tTable.add(imageBg).padBottom(-110.0f).padLeft(-96.0f);
        content.add(new Stack(tTable, vTable)).size(100.0f, 50.0f).expand().left();
        content.setClip(true);
        Table dTable = new Table();
        Label description = new Label((CharSequence)artefactType.description, new Label.LabelStyle(this.assets.getFont().arial12, Color.WHITE));
        description.setWrap(true);
        dTable.add(description).width(153.0f).row();
        final AvatarData avatar = this.model.player.selectedAvatar;
        if (avatar.level < artefactType.minLevel) {
            Label lockLevel = new Label((CharSequence)this.model.lang.format("window.workshop.tech.need_level", artefactType.minLevel), new Label.LabelStyle(this.assets.getFont().arial12, Color.RED));
            dTable.add(lockLevel).growX().bottom();
        }
        content.add(dTable).expandY();
        TextureAtlas.AtlasRegion region = this.assets.getCommonAtlas().findRegion("energy_icon_small");
        region.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Image energyIcon = new Image(region);
        Label price = new Label((CharSequence)String.valueOf(artefactType.price * 5), new Label.LabelStyle(this.assets.getFont().arialBold14, Color.valueOf("#FFFD81")));
        Table pTable = new Table();
        pTable.defaults().space(6.0f);
        pTable.add(energyIcon);
        pTable.add(price);
        TextButton.TextButtonStyle btnStyle = new TextButton.TextButtonStyle();
        btnStyle.up = this.assets.getNinePatchDrawable(this.atlas, "blue_btn_up", 5, 5, 2, 2);
        btnStyle.down = this.assets.getNinePatchDrawable(this.atlas, "blue_btn_down", 5, 5, 2, 2);
        btnStyle.disabled = this.assets.getNinePatchDrawable(this.atlas, "blue_btn_disable", 5, 5, 2, 2);
        btnStyle.font = this.assets.getFont().arialBold14;
        btnStyle.fontColor = Color.WHITE;
        TextButton buyButton = new TextButton(this.model.lang.get("window.workshop.buy"), btnStyle);
        buyButton.setDisabled(avatar.level < artefactType.minLevel);
        buyButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (avatar.getArtefactByType(artefactType.id) == null && avatar.artefacts.size >= avatar.availNumArtefact) {
                    WarningWindow wnd = WarningWindow.create(WarningWindow.Type.INFO, "window.workshop.artefacts", "window.workshop.artefacts.no_slots_available", "window.confirm.ok");
                    WorkshopArtefactItem.this.windowManager.open(wnd, true);
                    return;
                }
                if (FinanceManager.checkEnergy(avatar, artefactType.price * 5)) {
                    Commander.getInstance().ArtefactActionBuy(artefactType.id, 5);
                    WorkshopArtefactItem.this.soundSystem.fx.play("sound/fx/3. Buy.mp3");
                }
            }
        });
        Table lTable = new Table();
        lTable.defaults().space(10.0f);
        lTable.add(pTable).row();
        lTable.add(buyButton);
        content.add(lTable).expand().pad(6.0f).padRight(10.0f);
        Image background = new Image(this.assets.getNinePatchDrawable(this.atlas, "item_slot_bg", 5, 5, 20, 10));
        Table slot = new Table();
        slot.add(name).expandX().height(20.0f).top().row();
        slot.add(content).height(85.0f).expand().growX();
        this.add(new Stack(background, slot)).grow();
    }

    public static String getImageKey(ArtefactType artefactType) {
        switch (artefactType.code) {
            case "dead_ray": {
                return "artefact_ray_item_icon";
            }
            case "double_power": {
                return "artefact_power_item_icon";
            }
            case "dynamic_shield": {
                return "artefact_shield_item_icon";
            }
            case "heal": {
                return "artefact_heal_item_icon";
            }
        }
        return null;
    }
}

