/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.workshop.artefact;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.ArtefactData;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.workshop.artefact.WorkshopArtefactSlot;
import com.tpwar.game.windows.workshop.artefact.WorkshopArtefactView;
import com.tpwar.storage.Storage;

public class WorkshopArtefactPanel
extends Table {
    private final Model model = Model.getInstance();
    private final Assets assets = Assets.getInstance();
    private final Storage storage = Storage.getInstance();
    private Array<WorkshopArtefactSlot> slots = new Array();

    public WorkshopArtefactPanel() {
        WorkshopArtefactSlot slot;
        int i;
        this.defaults().space(10.0f);
        Table artefactsTabs = new Table();
        TextureAtlas atlas = this.assets.getWindowAtlas();
        artefactsTabs.setBackground(this.assets.getNinePatchDrawable(atlas, "content_background", 10, 10, 6, 6));
        artefactsTabs.pad(6.0f);
        artefactsTabs.defaults().growX().size(72.0f, 57.0f).space(20.0f);
        AvatarData avatarData = this.model.player.selectedAvatar;
        for (i = 0; i < Math.min(avatarData.artefacts.size, 4); ++i) {
            ArtefactData artefactData = avatarData.artefacts.get(i);
            slot = new WorkshopArtefactSlot(artefactData, i + 1 > avatarData.availNumArtefact);
            artefactsTabs.add(slot);
            this.slots.add(slot);
        }
        for (i = avatarData.artefacts.size; i < 4; ++i) {
            slot = i + 1 <= avatarData.availNumArtefact ? new WorkshopArtefactSlot(null, false) : new WorkshopArtefactSlot(null, true);
            artefactsTabs.add(slot);
            this.slots.add(slot);
        }
        Table currentView = new Table();
        currentView.setBackground(this.assets.getNinePatchDrawable(atlas, "content_background", 10, 10, 6, 6));
        currentView.pad(6.0f);
        currentView.add(new WorkshopArtefactView(this.storage.artefactType.getAll())).growX();
        this.add(artefactsTabs).expandX().row();
        this.add(currentView).growX();
    }

    public void update() {
        AvatarData avatarData = this.model.player.selectedAvatar;
        for (int i = 0; i < 4; ++i) {
            ArtefactData artefactData = null;
            if (i < avatarData.artefacts.size) {
                artefactData = avatarData.artefacts.get(i);
            }
            WorkshopArtefactSlot artefactSlot = this.slots.get(i);
            artefactSlot.setLocked(i >= avatarData.availNumArtefact);
            artefactSlot.update(artefactData);
        }
    }
}

