/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.workshop.artefact;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.ArtefactData;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.player.PlayerData;
import com.tpwar.game.managers.FinanceManager;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.net.Commander;
import com.tpwar.sound.SoundSystem;
import com.tpwar.storage.avatar.ArtefactType;

public class WorkshopArtefactSlot
extends Table {
    private final Assets assets = Assets.getInstance();
    private final Commander commander = Commander.getInstance();
    private final Model model = Model.getInstance();
    private final SoundSystem soundSystem = SoundSystem.getInstance();
    private final WindowManager windowManager = WindowManager.getInstance();
    private final TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/workshop.atlas");
    private Image background;
    private Image artefactIcon;
    private long artefactTypeId = 0L;
    private ClickListener clickListener;
    private ShaderProgram shader;
    private ArtefactData artefactData;
    private boolean locked;

    public WorkshopArtefactSlot(ArtefactData artefactData, boolean locked) {
        this.artefactData = artefactData;
        this.locked = locked;
        this.shader = (ShaderProgram)this.assets.get("tint_shader");
        this.background = new Image(this.assets.getNinePatchDrawable(this.atlas, "category_slot_bg", 5, 5, 5, 5));
        this.update(artefactData);
        this.clickListener = new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                final PlayerData player = WorkshopArtefactSlot.this.model.player;
                AvatarData avatar = player.selectedAvatar;
                if (WorkshopArtefactSlot.this.locked) {
                    final int needCrystals = avatar.availNumArtefact < 2 ? 50 : 75;
                    FinanceManager.showConfirmWindow(WorkshopArtefactSlot.this.model.lang.format("window.workshop.buy_slot", needCrystals), new ClickListener(){

                        @Override
                        public void clicked(InputEvent event, float x, float y) {
                            if (FinanceManager.checkCrystals(player, needCrystals)) {
                                WorkshopArtefactSlot.this.windowManager.closeCurrentWindow();
                                WorkshopArtefactSlot.this.commander.ArtefactActionBuySlot();
                                WorkshopArtefactSlot.this.soundSystem.fx.play("sound/fx/28. Buy_crystal.mp3");
                            }
                        }
                    });
                } else if (WorkshopArtefactSlot.this.artefactData != null) {
                    final WarningWindow wnd = WarningWindow.create(WarningWindow.Type.INFO, "window.workshop.artefacts", "window.workshop.artefacts.throw_message", "window.workshop.artefacts.throw");
                    wnd.setActionlistener(new ClickListener(){

                        @Override
                        public void clicked(InputEvent event, float x, float y) {
                            wnd.closeHandler();
                            WorkshopArtefactSlot.this.commander.ArtefactActionRemove(WorkshopArtefactSlot.this.artefactData.id);
                            WorkshopArtefactSlot.this.soundSystem.fx.play("sound/fx/4. Sell.mp3");
                        }
                    });
                    WorkshopArtefactSlot.this.windowManager.open(wnd, true);
                }
            }
        };
        this.addListener(this.clickListener);
    }

    public void update(ArtefactData artefactData) {
        this.artefactData = artefactData;
        this.reset();
        Label.LabelStyle labelStyle = new Label.LabelStyle(this.assets.getFont().arial12, Color.WHITE);
        if (artefactData != null) {
            ArtefactType artefactType = artefactData.getType();
            if (this.artefactTypeId != artefactType.id) {
                switch (artefactType.code) {
                    case "dead_ray": {
                        this.artefactIcon = new Image(this.atlas.findRegion("artefact_ray_icon"));
                        break;
                    }
                    case "double_power": {
                        this.artefactIcon = new Image(this.atlas.findRegion("artefact_power_icon"));
                        break;
                    }
                    case "dynamic_shield": {
                        this.artefactIcon = new Image(this.atlas.findRegion("artefact_shield_icon"));
                        break;
                    }
                    case "heal": {
                        this.artefactIcon = new Image(this.atlas.findRegion("artefact_heal_icon"));
                        break;
                    }
                }
            }
            this.artefactTypeId = artefactType.id;
            Table container = new Table();
            Table numTable = new Table();
            numTable.setBackground(this.assets.getNinePatchDrawable(this.atlas, "artefact_num_place", 6, 6, 2, 4));
            Label numLabel = new Label((CharSequence)("x" + artefactData.count), labelStyle);
            numTable.add(numLabel);
            container.add(numTable).width(40.0f).expand().top().right().pad(2.0f).row();
            if (!this.locked) {
                Image bottom = new Image(this.assets.getDrawable(this.atlas, "artefact_bottom_line"));
                Label throwText = new Label((CharSequence)this.model.lang.get("window.workshop.artefacts.throw"), labelStyle);
                throwText.setAlignment(1);
                container.add(new Stack(bottom, throwText)).expand().bottom();
                this.add(new Stack(this.background, this.artefactIcon, container));
            } else {
                this.artefactIcon.getColor().a = 0.6f;
                container.getColor().a = 0.6f;
                this.add(new Stack(this.background, this.artefactIcon, container, new Container<Image>(new Image(this.atlas.findRegion("lock_btn_icon")))));
            }
        } else if (this.locked) {
            this.artefactIcon = new Image(this.atlas.findRegion("lock_btn_icon"));
            this.add(new Stack(this.background, new Container<Image>(this.artefactIcon))).grow();
        } else {
            Label empty = new Label((CharSequence)"\u041f\u0443\u0441\u0442\u043e", labelStyle);
            this.add(new Stack(this.background, new Container<Label>(empty))).grow();
        }
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.clickListener.isVisualPressed()) {
            batch.setShader(this.shader);
            this.shader.setUniformf("u_color", Color.LIGHT_GRAY);
        }
        super.draw(batch, parentAlpha);
        batch.setShader(null);
    }
}

