/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.workshop.other;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.managers.FinanceManager;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.net.Commander;
import com.tpwar.sound.SoundSystem;
import packet.Static;

public class WorkshopItem
extends Table {
    private final Assets assets = Assets.getInstance();
    private final Model model = Model.getInstance();
    private final WindowManager windowManager = WindowManager.getInstance();
    private final SoundSystem soundSystem = SoundSystem.getInstance();
    private final TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/workshop.atlas");

    public WorkshopItem(final Static.StaticItemType itemType) {
        String title = itemType.getName();
        Label name = new Label((CharSequence)title, new Label.LabelStyle(this.assets.getFont().arialBold14, Color.valueOf("#95DEFF")));
        Table content = new Table();
        Image itemImage = new Image(this.atlas.findRegion(itemType.getCode().toLowerCase()));
        int duration = itemType.getDuration() / 60;
        String valueText = this.model.lang.format("hour", duration);
        Label value = new Label((CharSequence)valueText, new Label.LabelStyle(this.assets.getFont().arialBold14, Color.valueOf("#FFCC4F")));
        Table iTable = new Table();
        iTable.add(itemImage).expandY().top().padTop(-4.0f);
        Table vTable = new Table();
        vTable.add(value).expandY().bottom();
        content.add(new Stack(iTable, vTable)).width(100.0f).expand().left();
        content.setClip(true);
        String text = itemType.getDescription();
        Table dTable = new Table();
        dTable.defaults().space(2.0f);
        Label description = new Label((CharSequence)text, new Label.LabelStyle(this.assets.getFont().arial12, Color.WHITE));
        description.setWrap(true);
        dTable.add(description).width(153.0f).row();
        content.add(dTable).expand().left();
        TextureAtlas.AtlasRegion region = this.assets.getCommonAtlas().findRegion("crystal_icon_small");
        region.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Image energyIcon = new Image(region);
        Label price = new Label((CharSequence)String.valueOf(itemType.getPrice()), new Label.LabelStyle(this.assets.getFont().arialBold14, Color.valueOf("#FFFD81")));
        Table pTable = new Table();
        pTable.defaults().space(6.0f);
        pTable.add(energyIcon);
        pTable.add(price);
        TextButton.TextButtonStyle buyBtnStyle = new TextButton.TextButtonStyle();
        buyBtnStyle.up = this.assets.getNinePatchDrawable(this.atlas, "blue_btn_up", 5, 5, 2, 2);
        buyBtnStyle.down = this.assets.getNinePatchDrawable(this.atlas, "blue_btn_down", 5, 5, 2, 2);
        buyBtnStyle.disabled = this.assets.getNinePatchDrawable(this.atlas, "blue_btn_disable", 5, 5, 2, 2);
        buyBtnStyle.font = this.assets.getFont().arialBold14;
        buyBtnStyle.fontColor = Color.WHITE;
        AvatarData avatar = this.model.player.selectedAvatar;
        TextButton actionButton = new TextButton(this.model.lang.get("window.workshop.buy"), buyBtnStyle);
        actionButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (FinanceManager.checkCrystals(WorkshopItem.this.model.player, itemType.getPrice())) {
                    FinanceManager.showConfirmWindow(itemType.getPrice(), new ClickListener(){

                        @Override
                        public void clicked(InputEvent event, float x, float y) {
                            WorkshopItem.this.windowManager.closeCurrentWindow();
                            WorkshopItem.this.windowManager.closeAll();
                            WorkshopItem.this.soundSystem.fx.play("sound/fx/28. Buy_crystal.mp3");
                            Commander.getInstance().ItemActionBuy(WorkshopItem.this.model.player.selectedAvatar.id, itemType.getId());
                        }
                    });
                }
            }
        });
        boolean isDisabled = avatar.items.containsKey(itemType.getId()) && this.model.getServerTime() < avatar.items.get(Long.valueOf((long)itemType.getId())).effectEndTime;
        actionButton.setDisabled(isDisabled);
        Table lTable = new Table();
        lTable.defaults().space(10.0f);
        lTable.add(pTable).row();
        lTable.add(actionButton);
        content.add(lTable).expand().pad(6.0f).padRight(10.0f);
        Image background = new Image(this.assets.getNinePatchDrawable(this.atlas, "item_slot_bg", 5, 5, 20, 10));
        Table slot = new Table();
        slot.add(name).expandX().height(20.0f).top().row();
        slot.add(content).minHeight(85.0f).expand().growX();
        this.add(new Stack(background, slot)).grow();
    }
}

