/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.workshop.other;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.managers.FinanceManager;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.net.Commander;
import com.tpwar.sound.SoundSystem;
import packet.Static;

public class WorkshopShieldItem
extends Table {
    private final Assets assets = Assets.getInstance();
    private final Model model = Model.getInstance();
    private final WindowManager windowManager = WindowManager.getInstance();
    private final SoundSystem soundSystem = SoundSystem.getInstance();
    private final TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/workshop.atlas");

    public WorkshopShieldItem(final Static.StaticShieldType shieldType) {
        String title = "\u0429\u0438\u0442 " + shieldType.getTimeAction();
        Label name = new Label((CharSequence)title, new Label.LabelStyle(this.assets.getFont().arialBold14, Color.valueOf("#95DEFF")));
        Table content = new Table();
        Image shieldImage = new Image(this.atlas.findRegion("shield_icon"));
        String valueText = this.model.lang.format("hour", shieldType.getTimeAction());
        Label value = new Label((CharSequence)valueText, new Label.LabelStyle(this.assets.getFont().arialBold14, Color.valueOf("#FFCC4F")));
        Table iTable = new Table();
        iTable.add(shieldImage).expandY().top().padTop(-10.0f);
        Table vTable = new Table();
        vTable.add(value).expandY().bottom();
        Table tTable = new Table();
        TextureAtlas.AtlasRegion shieldImageBgRegion = this.atlas.findRegion("shield_icon");
        shieldImageBgRegion.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Image shieldImageBg = new Image(shieldImageBgRegion);
        shieldImageBg.setScale(4.0f);
        shieldImageBg.setColor(Color.WHITE.cpy());
        shieldImageBg.getColor().a = 0.1f;
        tTable.add(shieldImageBg).padBottom(-145.0f).padLeft(-120.0f);
        content.add(new Stack(tTable, iTable, vTable)).size(100.0f, 50.0f).expand().left();
        content.setClip(true);
        String text = "\u0417\u0430\u0449\u0438\u0442\u0430 \u043e\u0442 \u043d\u0430\u043f\u0430\u0434\u0435\u043d\u0438\u044f, \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442 \u043d\u0430 \u043f\u043b\u0430\u043d\u0435\u0442\u0430\u0445 \u0444\u0440\u0430\u043a\u0446\u0438\u0439 \u0438 \u0432\u0440\u0430\u0442, \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u043d\u0430\u043f\u0430\u0434\u0435\u043d\u0438\u0438 \u043d\u0430 \u0438\u0433\u0440\u043e\u043a\u0430. \u041f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u0441\u0442\u0440\u043e\u0438\u0442\u044c \u0430\u0440\u043c\u0438\u044e \u043f\u0440\u0438 \u0437\u0430\u0445\u0432\u0430\u0447\u0435\u043d\u043d\u043e\u0439 \u043f\u043b\u0430\u043d\u0435\u0442\u0435";
        Table dTable = new Table();
        dTable.defaults().space(2.0f);
        Label description = new Label((CharSequence)text, new Label.LabelStyle(this.assets.getFont().arial12, Color.WHITE));
        description.setWrap(true);
        dTable.add(description).width(153.0f).row();
        content.add(dTable).expand().left();
        TextureAtlas.AtlasRegion region = this.assets.getCommonAtlas().findRegion("crystal_icon_small");
        region.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Image energyIcon = new Image(region);
        Label price = new Label((CharSequence)String.valueOf(shieldType.getPrice()), new Label.LabelStyle(this.assets.getFont().arialBold14, Color.valueOf("#FFFD81")));
        Table pTable = new Table();
        pTable.defaults().space(6.0f);
        pTable.add(energyIcon);
        pTable.add(price);
        TextButton.TextButtonStyle buyBtnStyle = new TextButton.TextButtonStyle();
        buyBtnStyle.up = this.assets.getNinePatchDrawable(this.atlas, "blue_btn_up", 5, 5, 2, 2);
        buyBtnStyle.down = this.assets.getNinePatchDrawable(this.atlas, "blue_btn_down", 5, 5, 2, 2);
        buyBtnStyle.disabled = this.assets.getNinePatchDrawable(this.atlas, "blue_btn_disable", 5, 5, 2, 2);
        buyBtnStyle.font = this.assets.getFont().arialBold14;
        buyBtnStyle.fontColor = Color.WHITE;
        AvatarData avatar = this.model.player.selectedAvatar;
        TextButton actionButton = new TextButton(this.model.lang.get("window.workshop.buy"), buyBtnStyle);
        actionButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (FinanceManager.checkCrystals(WorkshopShieldItem.this.model.player, shieldType.getPrice())) {
                    FinanceManager.showConfirmWindow(shieldType.getPrice(), new ClickListener(){

                        @Override
                        public void clicked(InputEvent event, float x, float y) {
                            WorkshopShieldItem.this.windowManager.closeCurrentWindow();
                            WorkshopShieldItem.this.windowManager.closeAll();
                            WorkshopShieldItem.this.soundSystem.fx.play("sound/fx/28. Buy_crystal.mp3");
                            Commander.getInstance().ShieldActionBuy(WorkshopShieldItem.this.model.player.selectedAvatar.id, shieldType.getId());
                        }
                    });
                }
            }
        });
        actionButton.setDisabled(avatar.shieldIsActive());
        Table lTable = new Table();
        lTable.defaults().space(10.0f);
        lTable.add(pTable).row();
        lTable.add(actionButton);
        content.add(lTable).expand().pad(6.0f).padRight(10.0f);
        Image background = new Image(this.assets.getNinePatchDrawable(this.atlas, "item_slot_bg", 5, 5, 20, 10));
        Table slot = new Table();
        slot.add(name).expandX().height(20.0f).top().row();
        slot.add(content).minHeight(85.0f).expand().growX();
        this.add(new Stack(background, slot)).grow();
    }
}

