/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.workshop.other;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.domain.Model;
import com.tpwar.game.managers.FinanceManager;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.net.Commander;
import com.tpwar.sound.SoundSystem;
import com.tpwar.storage.Storage;
import packet.Static;

public class WorkshopTimeWarpItem
extends Table {
    private final Assets assets = Assets.getInstance();
    private final Model model = Model.getInstance();
    private final Storage storage = Storage.getInstance();
    private final WindowManager windowManager = WindowManager.getInstance();
    private final Commander commander = Commander.getInstance();
    private final SoundSystem soundSystem = SoundSystem.getInstance();
    private final TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/workshop.atlas");

    public WorkshopTimeWarpItem() {
        Label name = new Label((CharSequence)"\u0418\u0441\u043a\u0440\u0438\u0432\u0438\u0442\u0435\u043b\u044c \u0432\u0440\u0435\u043c\u0435\u043d\u0438", new Label.LabelStyle(this.assets.getFont().arialBold14, Color.valueOf("#95DEFF")));
        Table content = new Table();
        Image shieldImage = new Image(this.atlas.findRegion("time_warp_icon"));
        Label value = new Label((CharSequence)"24 \u0447\u0430\u0441\u0430", new Label.LabelStyle(this.assets.getFont().arialBold14, Color.valueOf("#FFCC4F")));
        Table iTable = new Table();
        iTable.add(shieldImage).expandY().top();
        Table vTable = new Table();
        vTable.add(value).expandY().bottom();
        Table tTable = new Table();
        TextureAtlas.AtlasRegion shieldImageBgRegion = this.atlas.findRegion("time_warp_icon");
        shieldImageBgRegion.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Image shieldImageBg = new Image(shieldImageBgRegion);
        shieldImageBg.setScale(4.0f);
        shieldImageBg.setColor(Color.WHITE.cpy());
        shieldImageBg.getColor().a = 0.1f;
        tTable.add(shieldImageBg).padBottom(-125.0f).padLeft(-100.0f);
        content.add(new Stack(tTable, iTable, vTable)).size(100.0f, 50.0f).expand().left();
        content.setClip(true);
        String text = "\u0418\u0441\u043a\u0440\u0438\u0432\u0438\u0442\u0435\u043b\u044c \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0443\u043c\u0435\u043d\u044c\u0448\u0438\u0442 \u0432\u0440\u0435\u043c\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u044e\u043d\u0438\u0442\u043e\u0432 \u043d\u0430 30% \u0432 \u0442\u0435\u0447\u0435\u043d\u0438\u0438 24 \u0447\u0430\u0441\u043e\u0432.";
        Table dTable = new Table();
        dTable.defaults().space(2.0f);
        Label description = new Label((CharSequence)text, new Label.LabelStyle(this.assets.getFont().arial12, Color.WHITE));
        description.setWrap(true);
        dTable.add(description).width(153.0f).row();
        content.add(dTable).expand().left();
        TextureAtlas.AtlasRegion region = this.assets.getCommonAtlas().findRegion("crystal_icon_small");
        region.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Image energyIcon = new Image(region);
        Label price = new Label((CharSequence)String.valueOf(20), new Label.LabelStyle(this.assets.getFont().arialBold14, Color.valueOf("#FFFD81")));
        Table pTable = new Table();
        pTable.defaults().space(6.0f);
        pTable.add(energyIcon);
        pTable.add(price);
        TextButton.TextButtonStyle buyBtnStyle = new TextButton.TextButtonStyle();
        buyBtnStyle.up = this.assets.getNinePatchDrawable(this.atlas, "blue_btn_up", 5, 5, 2, 2);
        buyBtnStyle.down = this.assets.getNinePatchDrawable(this.atlas, "blue_btn_down", 5, 5, 2, 2);
        buyBtnStyle.disabled = this.assets.getNinePatchDrawable(this.atlas, "blue_btn_disable", 5, 5, 2, 2);
        buyBtnStyle.font = this.assets.getFont().arialBold14;
        buyBtnStyle.fontColor = Color.WHITE;
        final Static.StaticTimeWarpType timeWarpType = this.storage.timeWarp.get("acceleration");
        TextButton actionButton = new TextButton(this.model.lang.get("window.workshop.buy"), buyBtnStyle);
        actionButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (FinanceManager.checkCrystals(WorkshopTimeWarpItem.this.model.player, 20)) {
                    FinanceManager.showConfirmWindow(20, new ClickListener(){

                        @Override
                        public void clicked(InputEvent event, float x, float y) {
                            WorkshopTimeWarpItem.this.windowManager.closeCurrentWindow();
                            WorkshopTimeWarpItem.this.windowManager.closeAll();
                            WorkshopTimeWarpItem.this.commander.TimeWarpActionBuy(WorkshopTimeWarpItem.this.model.player.selectedAvatar.id, timeWarpType.getId());
                        }
                    });
                }
            }
        });
        Table lTable = new Table();
        lTable.defaults().space(10.0f);
        lTable.add(pTable).row();
        lTable.add(actionButton);
        content.add(lTable).expand().pad(6.0f).padRight(10.0f);
        Image background = new Image(this.assets.getNinePatchDrawable(this.atlas, "item_slot_bg", 5, 5, 20, 10));
        Table slot = new Table();
        slot.add(name).expandX().height(20.0f).top().row();
        slot.add(content).height(85.0f).expand().growX();
        this.add(new Stack(background, slot)).grow();
    }
}

