/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.workshop.tech;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.UnitTechData;
import com.tpwar.game.managers.FinanceManager;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.net.Commander;
import com.tpwar.sound.SoundSystem;
import com.tpwar.storage.Storage;
import com.tpwar.storage.unit.UnitTypeData;
import packet.Static;

public class WorkshopTechItem
extends Table {
    private final Assets assets = Assets.getInstance();
    private final Model model = Model.getInstance();
    private final Storage storage = Storage.getInstance();
    private final WindowManager windowManager = WindowManager.getInstance();
    private final Commander commander = Commander.getInstance();
    private final SoundSystem soundSystem = SoundSystem.getInstance();
    private final TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/workshop.atlas");
    private TextButton actionButton;
    private TextButton.TextButtonStyle sellBtnStyle;
    private Static.StaticUnitTech unitTech;
    private TextButton.TextButtonStyle buyBtnStyle;
    private Label price;

    public WorkshopTechItem(final Static.StaticUnitTech unitTech) {
        this.unitTech = unitTech;
        String nameKey = this.getNameKey(unitTech);
        Label name = new Label((CharSequence)this.model.lang.get(nameKey), new Label.LabelStyle(this.assets.getFont().arialBold14, Color.valueOf("#95DEFF")));
        Table content = new Table();
        Image techImage = new Image(this.atlas.findRegion(this.getImageKey(unitTech)));
        Label value = new Label((CharSequence)("+" + this.getValue(unitTech)), new Label.LabelStyle(this.assets.getFont().arialBold16, Color.valueOf("#FFCC4F")));
        Table vTable = new Table();
        vTable.defaults().space(6.0f);
        vTable.add(value).expandY();
        vTable.add(techImage);
        Table tTable = new Table();
        TextureAtlas.AtlasRegion texhImageBgRegion = this.atlas.findRegion(this.getImageKey(unitTech));
        texhImageBgRegion.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Image techImageBg = new Image(texhImageBgRegion);
        techImageBg.setScale(4.0f);
        techImageBg.setColor(Color.WHITE.cpy());
        techImageBg.getColor().a = 0.1f;
        tTable.add(techImageBg).padBottom(-125.0f).padLeft(-80.0f);
        content.add(new Stack(tTable, vTable)).size(100.0f, 50.0f).expand().left();
        content.setClip(true);
        UnitTypeData unitTypeData = this.storage.unitType.get(unitTech.getUnitTypeId());
        String text = this.model.lang.format("window.workshop.tech.info", unitTech.getUnitTypeId() == 0L ? "\u0432\u0441\u0435\u0445 \u044e\u043d\u0438\u0442\u043e\u0432" : "\u044e\u043d\u0438\u0442\u0430 " + unitTypeData.name, this.getValue(unitTech));
        Table dTable = new Table();
        dTable.defaults().space(2.0f);
        Label description = new Label((CharSequence)text, new Label.LabelStyle(this.assets.getFont().arial12, Color.WHITE));
        description.setWrap(true);
        dTable.add(description).width(153.0f).row();
        AvatarData avatar = this.model.player.selectedAvatar;
        if (avatar.level < unitTech.getMinLevel()) {
            Label lockLevel = new Label((CharSequence)this.model.lang.format("window.workshop.tech.need_level", unitTech.getMinLevel()), new Label.LabelStyle(this.assets.getFont().arial12, Color.RED));
            dTable.add(lockLevel).growX().bottom();
        }
        content.add(dTable).expandY();
        TextureAtlas.AtlasRegion region = this.assets.getCommonAtlas().findRegion("energy_icon_small");
        region.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Image energyIcon = new Image(region);
        this.price = new Label((CharSequence)String.valueOf(unitTech.getPrice()), new Label.LabelStyle(this.assets.getFont().arialBold14, Color.valueOf("#FFFD81")));
        Table pTable = new Table();
        pTable.defaults().space(6.0f);
        pTable.add(energyIcon);
        pTable.add(this.price);
        this.buyBtnStyle = new TextButton.TextButtonStyle();
        this.buyBtnStyle.up = this.assets.getNinePatchDrawable(this.atlas, "blue_btn_up", 5, 5, 2, 2);
        this.buyBtnStyle.down = this.assets.getNinePatchDrawable(this.atlas, "blue_btn_down", 5, 5, 2, 2);
        this.buyBtnStyle.disabled = this.assets.getNinePatchDrawable(this.atlas, "blue_btn_disable", 5, 5, 2, 2);
        this.buyBtnStyle.font = this.assets.getFont().arialBold14;
        this.buyBtnStyle.fontColor = Color.WHITE;
        this.sellBtnStyle = new TextButton.TextButtonStyle();
        this.sellBtnStyle.up = this.assets.getNinePatchDrawable(this.atlas, "pink_btn_up", 5, 5, 2, 2);
        this.sellBtnStyle.down = this.assets.getNinePatchDrawable(this.atlas, "pink_btn_down", 5, 5, 2, 2);
        this.sellBtnStyle.font = this.assets.getFont().arialBold14;
        this.sellBtnStyle.fontColor = Color.WHITE;
        this.actionButton = new TextButton("", this.buyBtnStyle);
        this.actionButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                final AvatarData avatar = WorkshopTechItem.this.model.player.selectedAvatar;
                if (avatar.hasUnitTech(unitTech.getId())) {
                    FinanceManager.showConfirmWindow(WorkshopTechItem.this.model.lang.get("window.workshop.tech.sell"), new ClickListener(){

                        @Override
                        public void clicked(InputEvent event, float x, float y) {
                            WorkshopTechItem.this.windowManager.closeCurrentWindow();
                            UnitTechData avatarTech = avatar.getTechByTypeId(unitTech.getId());
                            if (avatarTech != null) {
                                WorkshopTechItem.this.commander.UnitTechActionSell(avatarTech.id);
                                WorkshopTechItem.this.soundSystem.fx.play("sound/fx/4. Sell.mp3");
                            }
                        }
                    });
                } else if (avatar.hasUnitTechByParamType(unitTech.getParamType())) {
                    WarningWindow wnd = WarningWindow.create(WarningWindow.Type.INFO, "window.workshop.tech", "window.workshop.tech.warn", "window.confirm.ok");
                    WorkshopTechItem.this.windowManager.open(wnd, true);
                } else if (FinanceManager.checkEnergy(avatar, unitTech.getPrice())) {
                    WorkshopTechItem.this.commander.UnitTechActionBuy(unitTech.getId());
                    WorkshopTechItem.this.soundSystem.fx.play("sound/fx/3. Buy.mp3");
                }
            }
        });
        Table lTable = new Table();
        lTable.defaults().space(10.0f);
        lTable.add(pTable).row();
        lTable.add(this.actionButton);
        content.add(lTable).expand().pad(6.0f).padRight(10.0f);
        Image background = new Image(this.assets.getNinePatchDrawable(this.atlas, "item_slot_bg", 5, 5, 20, 10));
        Table slot = new Table();
        slot.add(name).expandX().height(20.0f).top().row();
        slot.add(content).height(85.0f).expand().growX();
        this.add(new Stack(background, slot)).grow();
    }

    public void updateStatus(boolean have) {
        if (have) {
            this.actionButton.setDisabled(false);
            this.actionButton.setStyle(this.sellBtnStyle);
            this.actionButton.setText(this.model.lang.get("window.workshop.sell"));
            this.price.setText(String.valueOf((int)((float)this.unitTech.getPrice() * 0.7f)));
        } else {
            AvatarData avatar = this.model.player.selectedAvatar;
            this.actionButton.setDisabled(avatar.level < this.unitTech.getMinLevel());
            this.actionButton.setStyle(this.buyBtnStyle);
            this.actionButton.setText(this.model.lang.get("window.workshop.buy"));
            this.price.setText(this.unitTech.getPrice());
        }
    }

    private String getImageKey(Static.StaticUnitTech unitTech) {
        if (unitTech.getDamage() > 0) {
            return "tech_damage_icon";
        }
        if (unitTech.getArmor() > 0) {
            return "tech_armor_icon";
        }
        if (unitTech.getHealth() > 0) {
            return "tech_health_icon";
        }
        return null;
    }

    private String getNameKey(Static.StaticUnitTech unitTech) {
        if (unitTech.getDamage() > 0) {
            return "window.workshop.tech.damage";
        }
        if (unitTech.getArmor() > 0) {
            return "window.workshop.tech.armor";
        }
        if (unitTech.getHealth() > 0) {
            return "window.workshop.tech.health";
        }
        return null;
    }

    private int getValue(Static.StaticUnitTech unitTech) {
        if (unitTech.getDamage() > 0) {
            return unitTech.getDamage();
        }
        if (unitTech.getArmor() > 0) {
            return unitTech.getArmor();
        }
        if (unitTech.getHealth() > 0) {
            return unitTech.getHealth();
        }
        return 0;
    }

    public Static.StaticUnitTech getUnitTech() {
        return this.unitTech;
    }
}

