/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.workshop.tech;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.workshop.tech.WorkshopTechView;
import com.tpwar.game.windows.workshop.tech.WorkshopUnitTab;
import com.tpwar.storage.Storage;
import com.tpwar.storage.unit.UnitTypeData;
import java.util.List;
import packet.Static;

public class WorkshopTechPanel
extends Table {
    private static final Storage storage = Storage.getInstance();
    private static final Assets assets = Assets.getInstance();
    private final ObjectMap<Long, ObjectMap<Integer, WorkshopTechView>> viewByUnitType = new ObjectMap();
    private final Table unitTabs;
    private final Table currentView;
    private long currentUnitType = 0L;
    private int currentParameter = 0;
    private ButtonGroup<WorkshopUnitTab> buttons;

    public WorkshopTechPanel() {
        this.defaults().space(10.0f);
        TextureAtlas atlas = assets.getWindowAtlas();
        this.currentView = new Table();
        this.currentView.setBackground(assets.getNinePatchDrawable(atlas, "content_background", 10, 10, 6, 6));
        this.currentView.pad(6.0f);
        Array<UnitTypeData> unitTypes = WorkshopTechPanel.storage.unitType.getAll();
        for (UnitTypeData unitTypeData : unitTypes) {
            this.createView(unitTypeData.id);
        }
        this.createView(0L);
        this.unitTabs = new Table();
        this.unitTabs.setBackground(assets.getNinePatchDrawable(atlas, "content_background", 10, 10, 6, 6));
        this.unitTabs.pad(6.0f);
        this.unitTabs.defaults().grow().width(72.0f).space(20.0f);
        ClickListener clickListener = new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                WorkshopTechPanel.this.currentUnitType = (Long)event.getTarget().getUserObject();
                WorkshopTechPanel.this.updateView();
            }
        };
        this.buttons = new ButtonGroup();
        WorkshopUnitTab allUnitsBtn = this.createBtn("all");
        allUnitsBtn.addListener(clickListener);
        this.unitTabs.add(allUnitsBtn);
        this.buttons.add(allUnitsBtn);
        WorkshopUnitTab hamerUnitBtn = this.createBtn("hamer");
        hamerUnitBtn.addListener(clickListener);
        this.unitTabs.add(hamerUnitBtn);
        this.buttons.add(hamerUnitBtn);
        WorkshopUnitTab farnUnitBtn = this.createBtn("farn");
        farnUnitBtn.addListener(clickListener);
        this.unitTabs.add(farnUnitBtn);
        this.buttons.add(farnUnitBtn);
        WorkshopUnitTab havyUnitBtn = this.createBtn("havy");
        havyUnitBtn.addListener(clickListener);
        this.unitTabs.add(havyUnitBtn);
        this.buttons.add(havyUnitBtn);
        this.add(this.unitTabs).expandX().row();
        this.add(this.currentView).growX();
        this.updateView();
    }

    private WorkshopUnitTab createBtn(String unitTypeCode) {
        WorkshopUnitTab categoryButton = new WorkshopUnitTab(unitTypeCode, Color.WHITE);
        UnitTypeData unitTypeData = WorkshopTechPanel.storage.unitType.getUnitTypeByCode(unitTypeCode);
        categoryButton.setUserObject(unitTypeData != null ? unitTypeData.id : 0L);
        return categoryButton;
    }

    private void createView(long unitType) {
        ObjectMap<Integer, WorkshopTechView> viewByParameterType = new ObjectMap<Integer, WorkshopTechView>();
        this.viewByUnitType.put(unitType, viewByParameterType);
        for (int i = 0; i < 3; ++i) {
            List<Static.StaticUnitTech> techList = WorkshopTechPanel.storage.techType.getAvailTechList(unitType, i + 1);
            WorkshopTechView wtv = new WorkshopTechView(techList);
            viewByParameterType.put(i, wtv);
        }
    }

    public void setParameterType(int parameterType) {
        if (parameterType == this.currentParameter) {
            return;
        }
        this.currentParameter = parameterType;
        this.updateView();
    }

    public void updateView() {
        this.currentView.clear();
        ObjectMap<Integer, WorkshopTechView> viewByParameterType = this.viewByUnitType.get(this.currentUnitType);
        this.currentView.add(viewByParameterType.get(this.currentParameter)).growX();
    }

    public void update() {
        for (ObjectMap.Entry entry : this.viewByUnitType) {
            for (ObjectMap.Entry viewList : (ObjectMap)entry.value) {
                ((WorkshopTechView)viewList.value).update();
            }
        }
    }
}

