/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.workshop.tech;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.windows.workshop.tech.WorkshopTechItem;
import java.util.List;
import packet.Static;

public class WorkshopTechView
extends Table {
    private static Model model = Model.getInstance();
    private ScrollPane scrollPane;
    private Table table;
    private Array<WorkshopTechItem> list = new Array();

    public WorkshopTechView(List<Static.StaticUnitTech> techList) {
        AvatarData avatarData = WorkshopTechView.model.player.selectedAvatar;
        this.table = new Table();
        this.table.defaults().space(8.0f);
        for (int i = 0; i < techList.size(); ++i) {
            Static.StaticUnitTech sut = techList.get(i);
            WorkshopTechItem techItem = new WorkshopTechItem(sut);
            this.table.add(techItem).expand().row();
            techItem.updateStatus(avatarData.hasUnitTech(sut.getId()));
            this.list.add(techItem);
        }
        this.scrollPane = new ScrollPane((Actor)this.table);
        this.scrollPane.setTouchable(Touchable.childrenOnly);
        this.add(this.scrollPane).height(290.0f).growX();
    }

    public void update() {
        AvatarData avatarData = WorkshopTechView.model.player.selectedAvatar;
        for (WorkshopTechItem workshopTechItem : this.list) {
            Static.StaticUnitTech unitTech = workshopTechItem.getUnitTech();
            workshopTechItem.updateStatus(avatarData.hasUnitTech(unitTech.getId()));
        }
    }
}

