/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.workshop.tech;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.tpwar.domain.Model;
import com.tpwar.game.utils.Assets;

public class WorkshopUnitTab
extends Button {
    private static Assets assets = Assets.getInstance();
    private static TextureAtlas atlas = (TextureAtlas)assets.get("ui/workshop.atlas");
    private static Model model = Model.getInstance();
    private ShaderProgram shader = (ShaderProgram)assets.get("tint_shader");

    public WorkshopUnitTab(String unitTypeCode, Color color) {
        Button.ButtonStyle buttonStyle = new Button.ButtonStyle();
        buttonStyle.up = assets.getNinePatchDrawable(atlas, "category_slot_bg", 4, 4, 4, 4);
        this.setStyle(buttonStyle);
        TextureAtlas.AtlasRegion unitIcon = null;
        switch (unitTypeCode) {
            case "farn": {
                unitIcon = atlas.findRegion("unit_farn_icon");
                break;
            }
            case "hamer": {
                unitIcon = atlas.findRegion("unit_hamer_icon");
                break;
            }
            case "havy": {
                unitIcon = atlas.findRegion("unit_havy_icon");
                break;
            }
            default: {
                Label.LabelStyle labelStyle = new Label.LabelStyle(WorkshopUnitTab.assets.getFont().arialBold14, Color.WHITE);
                Label text = new Label((CharSequence)WorkshopUnitTab.model.lang.get("window.workshop.all_units"), labelStyle);
                text.setWrap(true);
                text.setAlignment(1);
                this.add(text).width(60.0f).expand();
            }
        }
        if (unitIcon != null) {
            this.add(new Image(unitIcon)).expand().top().padTop(4.0f).row();
        }
        this.getChild(0).setTouchable(Touchable.disabled);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.isChecked()) {
            batch.setShader(this.shader);
            this.shader.setUniformf("u_color", Color.LIGHT_GRAY);
        }
        super.draw(batch, parentAlpha);
        batch.setShader(null);
    }
}

