/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.lwjgl3;

import com.tpwar.domain.Credentials;
import com.tpwar.game.utils.StringUtils;
import com.tpwar.lwjgl3.oauth.CookieUtils;
import com.tpwar.lwjgl3.oauth.OAuthBrowser;
import com.tpwar.lwjgl3.oauth.OAuthGoogleHandler;
import com.tpwar.lwjgl3.oauth.OAuthVkHandler;
import com.tpwar.platform.LoginManager;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URISyntaxException;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import org.apache.http.client.utils.URIBuilder;

public class DesktopLoginManager
extends LoginManager {
    public static final String GOOGLE_CLIENT_ID = "302163690127-2jtba08v7fbqtoqa82167b5823pj01ql.apps.googleusercontent.com";
    public static final String GOOGLE_CLIENT_SECRET = "4RLEuskpQjPqAv0c-_kVFYrz";
    public static final String GOOGLE_AUTH_API_URL = "https://accounts.google.com/o/oauth2/v2/auth";
    public static final String VK_AUTH_API_URL = "https://oauth.vk.ru/authorize";
    public static final String VK_CLIENT_ID = "3905499";
    private final Credentials credentials;

    public DesktopLoginManager(Credentials credentials) {
        this.credentials = credentials;
        new JFXPanel();
        Platform.setImplicitExit(false);
        Platform.runLater(() -> {});
    }

    @Override
    public void signIn(LoginManager.ServiceType type) {
        switch (type) {
            case VK_ID: {
                Platform.runLater(() -> {
                    OAuthBrowser authBrowser = new OAuthBrowser();
                    OAuthVkHandler handler = new OAuthVkHandler(authBrowser, (accessToken, userId, email) -> {
                        authBrowser.close();
                        Platform.exit();
                        this.credentials.setType(LoginManager.ServiceType.VKONTAKTE);
                        this.credentials.setUid(userId);
                        this.credentials.setKey(accessToken);
                        this.credentials.setEmail(email);
                        this.credentials.setMacAddress(this.makeMacAddress());
                        this.setChanged();
                        this.notifyObservers();
                    });
                    String url = "";
                    try {
                        URIBuilder builder = new URIBuilder(VK_AUTH_API_URL);
                        builder.addParameter("client_id", VK_CLIENT_ID);
                        builder.addParameter("response_type", "token");
                        builder.addParameter("redirect_uri", "https://oauth.vk.ru/blank.html");
                        builder.addParameter("display", "mobile");
                        url = builder.build().toString();
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    authBrowser.login(url, handler);
                });
                break;
            }
            default: {
                Platform.runLater(() -> {
                    OAuthBrowser authBrowser = new OAuthBrowser();
                    OAuthGoogleHandler handler = new OAuthGoogleHandler(authBrowser, GOOGLE_CLIENT_ID, GOOGLE_CLIENT_SECRET, (accessToken, userId, email) -> {
                        authBrowser.close();
                        Platform.exit();
                        this.credentials.setType(type);
                        this.credentials.setUid(userId);
                        this.credentials.setKey(accessToken);
                        this.credentials.setEmail(email);
                        this.credentials.setMacAddress(this.makeMacAddress());
                        this.setChanged();
                        this.notifyObservers();
                    });
                    String url = "";
                    try {
                        URIBuilder builder = new URIBuilder(GOOGLE_AUTH_API_URL);
                        builder.addParameter("client_id", GOOGLE_CLIENT_ID);
                        builder.addParameter("response_type", "code");
                        builder.addParameter("scope", "email");
                        builder.addParameter("redirect_uri", "http://localhost");
                        builder.addParameter("access_type", "offline");
                        url = builder.build().toString();
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    authBrowser.login(url, handler);
                });
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    private String makeMacAddress() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            NetworkInterface ni = NetworkInterface.getByInetAddress(localHost);
            byte[] hardwareAddress = ni.getHardwareAddress();
            if (hardwareAddress != null) {
                String[] hexadecimal = new String[hardwareAddress.length];
                for (int i = 0; i < hardwareAddress.length; ++i) {
                    hexadecimal[i] = String.format("%02X", hardwareAddress[i]);
                }
                return StringUtils.join("-", hexadecimal).toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    public void signOut() {
        CookieUtils.clear();
        this.credentials.setKey(null);
        this.setChanged();
        this.notifyObservers();
    }
}

