/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.lwjgl3;

import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3WindowAdapter;
import com.tpwar.Teleports;
import com.tpwar.domain.Credentials;
import com.tpwar.lwjgl3.DesktopLoginManager;
import com.tpwar.lwjgl3.DesktopNotificationService;
import com.tpwar.lwjgl3.DesktopPurchaseManger;
import com.tpwar.lwjgl3.DesktopView;
import com.tpwar.lwjgl3.StartupHelper;
import com.tpwar.lwjgl3.oauth.OAuthHandler;
import com.tpwar.platform.ApplicationContext;
import com.tpwar.platform.LoginManager;
import java.net.URL;
import java.util.Map;
import javafx.application.Platform;

public class Lwjgl3Launcher {
    public static void main(String[] args) {
        if (StartupHelper.startNewJvmIfRequired()) {
            return;
        }
        Lwjgl3Launcher.createApplication(args);
    }

    private static Lwjgl3Application createApplication(String[] args) {
        Credentials credentials = new Credentials();
        if (args.length > 0) {
            Lwjgl3Launcher.parseUrl(credentials, args[0]);
        }
        DesktopView desktopView = new DesktopView();
        ApplicationContext context = new ApplicationContext(credentials, desktopView);
        context.setPushService(new DesktopNotificationService());
        context.setPurchaseManager(new DesktopPurchaseManger());
        context.setLoginManager(new DesktopLoginManager(credentials));
        return new Lwjgl3Application(new Teleports(context), Lwjgl3Launcher.getDefaultConfiguration());
    }

    private static Lwjgl3ApplicationConfiguration getDefaultConfiguration() {
        Lwjgl3ApplicationConfiguration configuration = new Lwjgl3ApplicationConfiguration();
        configuration.setTitle("The Teleports");
        configuration.useVsync(true);
        configuration.setPauseWhenMinimized(false);
        configuration.setWindowedMode(1024, 576);
        configuration.setForegroundFPS(60);
        configuration.setWindowIcon("icon128.png", "icon64.png", "icon32.png", "icon16.png");
        configuration.setWindowListener(new Lwjgl3WindowAdapter(){

            @Override
            public boolean closeRequested() {
                Platform.exit();
                return super.closeRequested();
            }
        });
        return configuration;
    }

    private static void parseUrl(Credentials credentials, String url) {
        try {
            Map<String, String> params = OAuthHandler.splitQuery(new URL(url));
            String accessToken = params.getOrDefault("access_token", "");
            String userId = params.getOrDefault("user_id", "");
            String authorizeUrl = params.getOrDefault("authorize_url", "");
            if (accessToken.isEmpty() && !authorizeUrl.isEmpty()) {
                params = OAuthHandler.splitQuery(new URL(authorizeUrl));
                accessToken = params.getOrDefault("access_token", "");
                userId = params.getOrDefault("user_id", "");
            }
            if (!accessToken.isEmpty() && !userId.isEmpty()) {
                credentials.setType(LoginManager.ServiceType.VKONTAKTE);
                credentials.setUid(userId);
                credentials.setKey(accessToken);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

