/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.lwjgl3.oauth;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.sun.webkit.network.CookieManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.CookieHandler;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class CookieUtils {
    private static final String COOKIE_FILE_NAME = "cookies.tmp";
    private static final String[] DAYS = new String[]{"Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Jan"};

    public static void saveCookies() {
        try {
            CookieManager cookieManager = (CookieManager)CookieHandler.getDefault();
            Field f = cookieManager.getClass().getDeclaredField("store");
            f.setAccessible(true);
            Object cookieStore = f.get(cookieManager);
            Field bucketsField = Class.forName("com.sun.webkit.network.CookieStore").getDeclaredField("buckets");
            bucketsField.setAccessible(true);
            Map buckets = (Map)bucketsField.get(cookieStore);
            f.setAccessible(true);
            LinkedHashMap cookiesToSave = new LinkedHashMap();
            Iterator iterator = buckets.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                String domain = (String)entry.getKey();
                Map cookies = (Map)entry.getValue();
                cookiesToSave.put(domain, cookies.values());
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(cookiesToSave);
            Path path = CookieUtils.getTempDirectory();
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            Files.write(Paths.get(path.toString() + File.separatorChar + COOKIE_FILE_NAME, new String[0]), json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadCookies() {
        try {
            Path path = CookieUtils.getTempDirectory();
            if (Files.notExists(path, new LinkOption[0])) {
                return;
            }
            byte[] bytes = Files.readAllBytes(Paths.get(path.toString() + File.separatorChar + COOKIE_FILE_NAME, new String[0]));
            String json = new String(bytes, StandardCharsets.UTF_8);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            Type type = new TypeToken<Map<String, Collection<CookieJson>>>(){}.getType();
            Map cookiesToLoad = (Map)gson.fromJson(json, type);
            for (String domain : cookiesToLoad.keySet()) {
                Collection cookies = (Collection)cookiesToLoad.get(domain);
                LinkedHashMap<String, List<String>> m = new LinkedHashMap<String, List<String>>();
                ArrayList<String> list = new ArrayList<String>();
                m.put("Set-Cookie", list);
                for (CookieJson cookie : cookies) {
                    list.add(CookieUtils.format(cookie.name, cookie.value, cookie.domain, cookie.path, cookie.expiryTime, cookie.secureOnly, cookie.httpOnly));
                }
                CookieHandler.getDefault().put(new URI("http://" + domain + "/"), m);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void clear() {
        CookieHandler.setDefault(new CookieManager());
        Path path = CookieUtils.getTempDirectory();
        try {
            Files.deleteIfExists(Paths.get(path.toString() + File.separatorChar + COOKIE_FILE_NAME, new String[0]));
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Path getTempDirectory() {
        Object tempDir = System.getProperty("java.io.tmpdir");
        tempDir = (String)tempDir + "tpwar" + File.separatorChar;
        return Paths.get((String)tempDir, new String[0]);
    }

    private static String format(String name, String value, String domain, String path, long maxAge, boolean isSecure, boolean isHttpOnly) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        StringBuilder buf = new StringBuilder();
        buf.setLength(0);
        buf.append(name).append('=').append(value == null ? "" : value);
        if (path != null && path.length() > 0) {
            buf.append(";Path=").append(path);
        }
        if (domain != null && domain.length() > 0) {
            buf.append(";Domain=").append(domain);
        }
        if (maxAge >= 0L) {
            buf.append(";Expires=");
            if (maxAge == 0L) {
                buf.append(CookieUtils.formatCookieDate(0L).trim());
            } else {
                buf.append(CookieUtils.formatCookieDate(System.currentTimeMillis() + 1000L * maxAge));
            }
            buf.append(";Max-Age=");
            buf.append(maxAge);
        }
        if (isSecure) {
            buf.append(";Secure");
        }
        if (isHttpOnly) {
            buf.append(";HttpOnly");
        }
        return buf.toString();
    }

    private static String formatCookieDate(long date) {
        GregorianCalendar gc = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gc.setTimeInMillis(date);
        int day_of_week = gc.get(7);
        int day_of_month = gc.get(5);
        int month = gc.get(2);
        int year = gc.get(1);
        year %= 10000;
        int epoch = (int)(date / 1000L % 86400L);
        int seconds = epoch % 60;
        int minutes = (epoch /= 60) % 60;
        int hours = epoch / 60;
        StringBuilder buf = new StringBuilder();
        buf.append(DAYS[day_of_week]);
        buf.append(',');
        buf.append(' ');
        CookieUtils.append2digits(buf, day_of_month);
        buf.append('-');
        buf.append(MONTHS[month]);
        buf.append('-');
        CookieUtils.append2digits(buf, year / 100);
        CookieUtils.append2digits(buf, year % 100);
        buf.append(' ');
        CookieUtils.append2digits(buf, hours);
        buf.append(':');
        CookieUtils.append2digits(buf, minutes);
        buf.append(':');
        CookieUtils.append2digits(buf, seconds);
        buf.append(" GMT");
        return buf.toString();
    }

    public static void append2digits(StringBuilder buf, int i) {
        if (i < 100) {
            buf.append((char)(i / 10 + 48));
            buf.append((char)(i % 10 + 48));
        }
    }

    private static class CookieJson {
        private String name;
        private String value;
        private Long expiryTime;
        private String domain;
        private String path;
        private boolean secureOnly;
        private boolean httpOnly;

        private CookieJson() {
        }
    }
}

