/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.lwjgl3.oauth;

import com.tpwar.lwjgl3.oauth.OAuthBrowser;
import com.tpwar.lwjgl3.oauth.OAuthCallback;
import com.tpwar.lwjgl3.oauth.OAuthHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import org.apache.commons.codec.Charsets;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class OAuthGoogleHandler
extends OAuthHandler {
    public static final String SCOPE_EMAIL = "email";
    public static final String GOOGLE_TOKEN_API_URL = "https://www.googleapis.com/oauth2/v4/token";
    public static final String GOOGLE_USER_INFO_URL = "https://www.googleapis.com/oauth2/v3/userinfo";
    private OAuthCallback callback;
    private String clientId;
    private String clientSecret;

    public OAuthGoogleHandler(OAuthBrowser browser, String clientId, String clientSecret, OAuthCallback callback) {
        super(browser);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.callback = callback;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject doGetAccessTokenRequest(String code) {
        try {
            URIBuilder builder = new URIBuilder(GOOGLE_TOKEN_API_URL);
            builder.addParameter("client_id", this.clientId);
            builder.addParameter("client_secret", this.clientSecret);
            builder.addParameter("response_type", "code");
            builder.addParameter("redirect_uri", "http://localhost");
            builder.addParameter("grant_type", "authorization_code");
            builder.addParameter("code", code);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPost httpPost = new HttpPost(builder.build());
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            httpPost.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.6613.119 Safari/537.36");
            try (CloseableHttpResponse response = httpClient.execute(httpPost);){
                if (response.getStatusLine().getStatusCode() == 200) {
                    String string = EntityUtils.toString(response.getEntity(), Charsets.UTF_8);
                    JSONObject jSONObject = new JSONObject(string);
                    return jSONObject;
                }
                System.out.println(EntityUtils.toString(response.getEntity(), Charsets.UTF_8));
                return null;
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
        if (newValue == Worker.State.FAILED) {
            try {
                String location = URLDecoder.decode(this.browser.getEngine().getLocation(), "UTF-8");
                Map<String, String> parameters = OAuthGoogleHandler.splitQuery(new URL(location));
                if (parameters.containsKey("code")) {
                    String accessCode = parameters.get("code");
                    JSONObject accessResult = this.doGetAccessTokenRequest(accessCode);
                    if (accessResult == null) {
                        return;
                    }
                    String idToken = accessResult.getString("id_token");
                    this.callback.result(idToken, "", "");
                }
            }
            catch (UnsupportedEncodingException | MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }
}

