/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.lwjgl3.oauth;

import com.tpwar.lwjgl3.oauth.OAuthBrowser;
import com.tpwar.lwjgl3.oauth.OAuthCallback;
import com.tpwar.lwjgl3.oauth.OAuthHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;

public class OAuthVkHandler
extends OAuthHandler {
    private final OAuthCallback callback;

    public OAuthVkHandler(OAuthBrowser browser, OAuthCallback callback) {
        super(browser);
        this.callback = callback;
    }

    @Override
    public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
        if (newValue == Worker.State.SUCCEEDED) {
            try {
                String location = URLDecoder.decode(this.browser.getEngine().getLocation(), StandardCharsets.UTF_8);
                Map<String, String> params = OAuthVkHandler.splitQuery(new URL(location));
                String accessToken = params.getOrDefault("access_token", "");
                String userId = params.getOrDefault("user_id", "");
                String authorizeUrl = params.getOrDefault("authorize_url", "");
                if (accessToken.isEmpty() && !authorizeUrl.isEmpty()) {
                    params = OAuthVkHandler.splitQuery(new URL(authorizeUrl));
                    accessToken = params.getOrDefault("access_token", "");
                    userId = params.getOrDefault("user_id", "");
                }
                if (!accessToken.isEmpty() && !userId.isEmpty()) {
                    this.callback.result(accessToken, userId, "");
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }
}

