/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.messages;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.messages.MessageListener;
import java.util.List;
import packet.Transport;

public class MessageDispatcher {
    private static final String TAG = MessageDispatcher.class.getSimpleName();
    private IntMap<Array<MessageListener>> hub = new IntMap();

    public void addListener(MessageListener listener, int code) {
        Array<MessageListener> listeners = this.hub.get(code);
        if (listeners == null) {
            listeners = new Array(false, 1);
            this.hub.put(code, listeners);
        }
        listeners.add(listener);
    }

    public void addListeners(MessageListener listener, int ... codes) {
        for (int code : codes) {
            this.addListener(listener, code);
        }
    }

    public void removeListener(MessageListener listener, int code) {
        Array<MessageListener> listeners = this.hub.get(code);
        if (listeners != null) {
            listeners.removeValue(listener, true);
        }
    }

    public void removeListeners(MessageListener listener, int ... codes) {
        for (int code : codes) {
            this.removeListener(listener, code);
        }
    }

    public void addListeners(MessageListener listener, List<Integer> list) {
        for (int code : list) {
            this.addListener(listener, code);
        }
    }

    public void removeListener(MessageListener listener, List<Integer> list) {
        for (int code : list) {
            this.removeListener(listener, code);
        }
    }

    public void removeListeners(MessageListener listener) {
        for (Array<MessageListener> listeners : this.hub.values()) {
            if (!listeners.contains(listener, true)) continue;
            listeners.removeValue(listener, true);
        }
    }

    public void clearListeners(int code) {
        this.hub.remove(code);
    }

    public void clearListeners(int ... codes) {
        for (int code : codes) {
            this.clearListeners(code);
        }
    }

    public void clearListeners() {
        this.hub.clear();
    }

    protected void dispatchMessage(int code, Object data, Transport.Packet msg) {
        try {
            Array<MessageListener> listeners = this.hub.get(code);
            if (listeners != null) {
                for (MessageListener l : listeners) {
                    l.handleMessage(code, data, msg);
                }
            }
        }
        catch (InvalidProtocolBufferException ex) {
            Gdx.app.error(TAG, ex.getMessage());
        }
    }
}

