/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.net;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum Cmd {
    UNKNOWN(0),
    Ping(1),
    Pong(2),
    Error(5),
    Ok(6),
    Logout(10),
    LoginResp(11),
    Login(12),
    LoginVk(13),
    ResetPassword(14),
    LoginFb(15),
    LoginGoogle(16),
    LoginVkId(17),
    SignupResp(40),
    Signup(41),
    SignupVk(42),
    SignupFb(43),
    SignupGoogle(44),
    SignupVkId(45),
    GetWorldList(71),
    WorldList(72),
    GetPlanetList(100),
    PlanetList(101),
    MoveToPlanet(102),
    GetAvatarList(200),
    AvatarList(201),
    SelectAvatar(202),
    CreateAvatar(203),
    AvatarDto(204),
    AvatarSelected(205),
    PlayerUpdate(206),
    BuyAvatarSlot(207),
    AvatarSlotPurchased(208),
    ResetAvatarSession(209),
    ChangeNameAvatar(210),
    CheckAvatarName(211),
    RemoveAvatar(212),
    PlayerUpdateToken(213),
    ChangeAvatarFraction(214),
    ChangeEmail(215),
    GetStaticContent(250),
    StaticContent(251),
    MoveToZone(302),
    AvatarActionMove(303),
    ZoneEventAvatarMove(304),
    AvatarUpdate(305),
    ZoneData(306),
    ZoneEventAvatar(307),
    ZoneEventAvatarRemove(308),
    ZoneEventBattle(309),
    ZoneEventBattleRemove(310),
    AvatarActionAttack(311),
    AvatarActionJoinBattle(312),
    CreateUnit(350),
    RemoveUnit(351),
    UpdateUnits(352),
    BuyUnits(353),
    BattleData(380),
    BattleActionAttack(381),
    BattleActionEscape(382),
    BattleEventRound(383),
    BattleEventReady(384),
    BattleEventResult(385),
    BattleActionExit(386),
    BattleActionJoin(387),
    GetBattleChronicles(390),
    BattleChronicles(391),
    ArtefactActionBuy(400),
    ArtefactActionRemove(401),
    ArtefactPurchased(402),
    ArtefactUpdate(403),
    ArtefactActionBuySlot(404),
    UnitTechActionBuy(420),
    UnitTechPurchased(421),
    UnitTechActionSell(422),
    UnitTechUpdate(423),
    UnitActionUpgrade(449),
    UnitUpgradeList(450),
    UnitActionRemoveUpgrades(451),
    UnitUpgradesRemoved(452),
    GateActionUsurp(470),
    GateActionLiberate(471),
    GateActionTeleport(472),
    BuildingUpdate(473),
    CitadelActionUsurp(474),
    BuildingStatus(478),
    BuildingInfoUpdate(479),
    OccupationStatus(480),
    GuildJoin(490),
    GuildLeave(491),
    GetAvatarTasks(492),
    AvatarTaskList(493),
    GuildRank(494),
    GetGuildTaskList(495),
    GuildTaskList(496),
    AvatarLevelUp(500),
    MineDig(510),
    MineStop(511),
    MineCompleted(512),
    MineReward(513),
    EventMessage(520),
    WorldStatus(530),
    PlanetStatus(531),
    CloseSession(540),
    SessionClosed(541),
    TreasureDig(550),
    TreasureStop(551),
    TreasureReward(552),
    TreasureInfo(553),
    TreasureStatus(554),
    FractionReward(560),
    ChatActionJoin(570),
    ChatActionLeave(571),
    ChatJoined(572),
    ChatLeft(573),
    ChatSendMessage(574),
    ChatMessage(575),
    SendMessage(590),
    AvatarMessage(591),
    MessageList(592),
    GetGateStats(600),
    GateStatsList(601),
    GetPaymentReward(610),
    PaymentReward(611),
    PaymentTransaction(612),
    ExchangeEnergyRequest(620),
    ExchangeEnergyResult(621),
    AvatarTutorialData(630),
    SaveTutorialStep(631),
    TimeWarpActionBuy(640),
    TimeWarpPurchased(641),
    TimeWarpList(642),
    ClanActionCreate(650),
    ClanData(651),
    GetClanList(652),
    ClanList(653),
    GetClanInvitationList(654),
    ClanInvitationList(655),
    GetClanApplicationList(656),
    ClanApplicationList(657),
    GetClanData(658),
    ClanEventInvite(659),
    ClanEventApplication(660),
    ClanDeleteInvitation(661),
    ClanDeleteApplication(662),
    ClanActionTake(663),
    ClanActionJoin(664),
    ClanActionLeave(665),
    ClanChangeDescription(666),
    ClanActionSearch(667),
    ClanSearchResult(668),
    ClanActionApplication(669),
    ClanActionExclude(670),
    ClanActionInvite(671),
    ClanChangeAutoApproval(672),
    GetGameRating(680),
    GameRating(681),
    AvatarPunish(700),
    PunishmentData(701),
    PunishmentList(702),
    DropPunishment(703),
    DailyBonusData(710),
    GiftList(720),
    TakeGift(721),
    GiftReceived(722),
    ListActivatedGifts(723),
    QuestUpdate(730),
    QuestTake(731),
    QuestTakeReward(732),
    QuestSkip(733),
    ShieldActionBuy(740),
    ShieldPurchased(741),
    Shield(742),
    StartArenaBattle(800),
    ArenaBattleList(801),
    RemoveArenaBattle(802),
    ItemActionBuy(820),
    ItemPurchased(821),
    ItemList(822),
    ItemActionUse(823),
    FINISH(1000);

    final int code;

    private Cmd(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static class Enums {
        private static final Map<Integer, Cmd> COMMAND_MAP = new HashMap<Integer, Cmd>();
        private static final List<Integer> ALLOW;
        private static final List<Integer> ALLOW_WITHOUT_SESSION;

        public static Cmd byInt(Integer i) {
            Cmd command = COMMAND_MAP.get(i);
            if (null == command) {
                command = UNKNOWN;
            }
            return command;
        }

        public static boolean isCloseSessionCommand(Integer cmd) {
            return cmd.equals(CloseSession.getCode());
        }

        public static boolean isAllow(Integer cmd) {
            return ALLOW.contains(cmd);
        }

        public static boolean isAllowWithoutSession(Integer cmd) {
            return ALLOW_WITHOUT_SESSION.contains(cmd);
        }

        static {
            for (Cmd command : Cmd.values()) {
                COMMAND_MAP.put(command.getCode(), command);
            }
            ALLOW = Arrays.asList(Login.getCode(), LoginVk.getCode(), Signup.getCode(), SignupVk.getCode(), LoginFb.getCode(), SignupFb.getCode());
            ALLOW_WITHOUT_SESSION = Arrays.asList(GetAvatarList.getCode(), SelectAvatar.getCode(), CreateAvatar.getCode(), GetStaticContent.getCode(), BuyAvatarSlot.getCode(), GetPaymentReward.getCode(), ResetAvatarSession.getCode(), ResetPassword.getCode(), Ping.getCode());
        }
    }
}

