/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.net;

import com.badlogic.gdx.pay.Transaction;
import com.tpwar.domain.Credentials;
import com.tpwar.net.Cmd;
import com.tpwar.net.Connection;
import packet.Arena;
import packet.Artefact;
import packet.Auth;
import packet.Avatars;
import packet.Battle;
import packet.Building;
import packet.Chat;
import packet.Clan;
import packet.Exchanger;
import packet.Fraction;
import packet.Gifts;
import packet.Guild;
import packet.Items;
import packet.Message;
import packet.Payment;
import packet.Planet;
import packet.Player;
import packet.Punishment;
import packet.Quest;
import packet.Rating;
import packet.Shield;
import packet.TimeWarp;
import packet.Treasure;
import packet.Unit;
import packet.Zone;

public class Commander {
    private static final Commander instance = new Commander();
    private Connection connection = Connection.getInstance();

    public void Ping() {
        if (this.connection.isConnected()) {
            this.connection.send(Cmd.Ping, null);
        }
    }

    public void sendTransaction(Transaction transaction) {
        Payment.TransactionDto.Builder msg = Payment.TransactionDto.newBuilder();
        msg.setOrderId(transaction.getOrderId());
        msg.setDate(transaction.getPurchaseTime().getTime());
        if (transaction.getPurchaseCostCurrency() != null) {
            msg.setCurrencyLocal(transaction.getPurchaseCostCurrency());
        }
        msg.setPriceLocal(transaction.getPurchaseCost());
        msg.setStoreName(transaction.getStoreName());
        msg.setTransactionData(transaction.getTransactionData());
        msg.setTransactionDataSignature(transaction.getTransactionDataSignature());
        msg.setIdentifier(transaction.getIdentifier());
        this.connection.send(Cmd.PaymentTransaction, msg.build());
    }

    public void TimeWarpActionBuy(long avatarId, long timeWarpTypeId) {
        TimeWarp.TimeWarpActionBuy.Builder msg = TimeWarp.TimeWarpActionBuy.newBuilder();
        msg.setAvatarId(avatarId);
        msg.setTimeWarpTypeId(timeWarpTypeId);
        this.connection.send(Cmd.TimeWarpActionBuy, msg.build());
    }

    public void PlayerUpdateToken(String token) {
        Player.UpdateToken.Builder msg = Player.UpdateToken.newBuilder();
        msg.setToken(token);
        this.connection.send(Cmd.PlayerUpdateToken, msg.build());
    }

    public void PlayerUpdateEmail(String email) {
        Player.UpdateEmail.Builder msg = Player.UpdateEmail.newBuilder();
        msg.setEmail(email);
        this.connection.send(Cmd.ChangeEmail, msg.build());
    }

    public void ShieldActionBuy(long avatarId, long shieldTypeId) {
        Shield.ShieldActionBuy.Builder msg = Shield.ShieldActionBuy.newBuilder();
        msg.setAvatarId(avatarId);
        msg.setShieldTypeId(shieldTypeId);
        this.connection.send(Cmd.ShieldActionBuy, msg.build());
    }

    public void ItemActionBuy(long avatarId, long itemTypeId) {
        Items.ItemActionBuy.Builder msg = Items.ItemActionBuy.newBuilder();
        msg.setAvatarId(avatarId);
        msg.setItemTypeId(itemTypeId);
        this.connection.send(Cmd.ItemActionBuy, msg.build());
    }

    public void GetGateStats() {
        this.connection.send(Cmd.GetGateStats, Fraction.GetGateStats.newBuilder().build());
    }

    public void BuyAvatarSlot() {
        Player.BuyAvatarSlot.Builder msg = Player.BuyAvatarSlot.newBuilder();
        this.connection.send(Cmd.BuyAvatarSlot, msg.build());
    }

    public void SkipQuest(long questId) {
        Quest.SkipQuest.Builder msg = Quest.SkipQuest.newBuilder();
        msg.setQuestId(questId);
        this.connection.send(Cmd.QuestSkip, msg.build());
    }

    public void SignupVk(String uid, String authKey) {
        Auth.SignupVk.Builder msg = Auth.SignupVk.newBuilder();
        msg.setVkUid(uid);
        msg.setVkKey(authKey);
        this.connection.send(Cmd.SignupVk, msg.build());
    }

    public void SignupVkId(String uid, String authKey) {
        Auth.SignupVk.Builder msg = Auth.SignupVk.newBuilder();
        msg.setVkUid(uid);
        msg.setVkKey(authKey);
        this.connection.send(Cmd.SignupVkId, msg.build());
    }

    public void SignupGoogle(Credentials credentials) {
        Auth.Signup.Builder msg = Auth.Signup.newBuilder();
        msg.setUsername(credentials.getUid());
        msg.setPassword(credentials.getKey());
        this.connection.send(Cmd.SignupGoogle, msg.build());
    }

    public void SignupFb(String uid, String key) {
        Auth.SignupFb.Builder msg = Auth.SignupFb.newBuilder();
        msg.setFbUid(uid);
        msg.setFbKey(key);
        this.connection.send(Cmd.SignupFb, msg.build());
    }

    public void LoginVk(Credentials credentials) {
        Auth.LoginVk.Builder msg = Auth.LoginVk.newBuilder();
        msg.setVkUid(credentials.getUid());
        msg.setVkKey(credentials.getKey());
        msg.setMacAddress(credentials.getMacAddress());
        this.connection.send(Cmd.LoginVk, msg.build());
    }

    public void LoginVkId(Credentials credentials) {
        Auth.LoginVk.Builder msg = Auth.LoginVk.newBuilder();
        msg.setVkUid(credentials.getUid());
        msg.setVkKey(credentials.getKey());
        msg.setMacAddress(credentials.getMacAddress());
        this.connection.send(Cmd.LoginVkId, msg.build());
    }

    public void LoginFb(String uid, String key) {
        Auth.LoginFb.Builder msg = Auth.LoginFb.newBuilder();
        msg.setFbUid(uid);
        msg.setFbKey(key);
        this.connection.send(Cmd.LoginFb, msg.build());
    }

    public void LoginGoogle(Credentials credentials) {
        Auth.Login.Builder msg = Auth.Login.newBuilder();
        msg.setUsername(credentials.getUid());
        msg.setPassword(credentials.getKey());
        msg.setMacAddress(credentials.getMacAddress());
        this.connection.send(Cmd.LoginGoogle, msg.build());
    }

    public void CreateAvatar(String name, Long fractionId) {
        Avatars.CreateAvatar.Builder msg = Avatars.CreateAvatar.newBuilder();
        msg.setName(name);
        msg.setFractionId(fractionId);
        this.connection.send(Cmd.CreateAvatar, msg.build());
    }

    public void CheckAvatarName(String name) {
        Avatars.CheckAvatarName.Builder msg = Avatars.CheckAvatarName.newBuilder();
        msg.setName(name);
        this.connection.send(Cmd.CheckAvatarName, msg.build());
    }

    public void AvatarPunish(String name, String reason, long time, int code) {
        Punishment.Punish.Builder msg = Punishment.Punish.newBuilder();
        msg.setName(name);
        msg.setDescription(reason);
        msg.setTime(time);
        msg.setCode(code);
        this.connection.send(Cmd.AvatarPunish, msg.build());
    }

    public void GetPunishments(String name) {
        Punishment.GetPunishmentList.Builder msg = Punishment.GetPunishmentList.newBuilder();
        msg.setName(name);
        this.connection.send(Cmd.PunishmentList, msg.build());
    }

    public void DropPunishment(long id) {
        Punishment.DropPunishment.Builder msg = Punishment.DropPunishment.newBuilder();
        msg.setId(id);
        this.connection.send(Cmd.DropPunishment, msg.build());
    }

    public void ResetAvatarSession(Long avatarId) {
        Avatars.ResetAvatarSession.Builder msg = Avatars.ResetAvatarSession.newBuilder();
        msg.setId(avatarId);
        this.connection.send(Cmd.ResetAvatarSession, msg.build());
    }

    public void ChangeAvatarName(long avatarId, String newName) {
        Avatars.ChangeAvatarName.Builder msg = Avatars.ChangeAvatarName.newBuilder();
        msg.setName(newName);
        msg.setId(avatarId);
        this.connection.send(Cmd.ChangeNameAvatar, msg.build());
    }

    public void ChangeAvatarFraction() {
        this.connection.send(Cmd.ChangeAvatarFraction, null);
    }

    public void RemoveAvatar(long avatarId) {
        Avatars.RemoveAvatar.Builder msg = Avatars.RemoveAvatar.newBuilder();
        msg.setId(avatarId);
        this.connection.send(Cmd.RemoveAvatar, msg.build());
    }

    public void SelectAvatar(long avatarId) {
        Avatars.SelectAvatar.Builder selectMsg = Avatars.SelectAvatar.newBuilder();
        selectMsg.setId(avatarId);
        this.connection.send(Cmd.SelectAvatar, selectMsg.build());
    }

    public void UnitActionRemoveUpgrades(long avatarId) {
        Unit.UnitActionRemoveUpgrades.Builder msg = Unit.UnitActionRemoveUpgrades.newBuilder();
        msg.setAvatarId(avatarId);
        this.connection.send(Cmd.UnitActionRemoveUpgrades, msg.build());
    }

    public void MoveToPlanet(long planetId) {
        Planet.MoveToPlanet.Builder msg = Planet.MoveToPlanet.newBuilder();
        msg.setPlanetId(planetId);
        this.connection.send(Cmd.MoveToPlanet, msg.build());
    }

    public void AvatarActionMove(int position) {
        Zone.AvatarActionMove.Builder msg = Zone.AvatarActionMove.newBuilder();
        msg.setPosition(position);
        this.connection.send(Cmd.AvatarActionMove, msg.build());
    }

    public void GuildJoin(long guildId) {
        Guild.GuildJoin.Builder msg = Guild.GuildJoin.newBuilder();
        msg.setGuildId(guildId);
        this.connection.send(Cmd.GuildJoin, msg.build());
    }

    public void GuildLeave() {
        Guild.GuildLeave.Builder msg = Guild.GuildLeave.newBuilder();
        this.connection.send(Cmd.GuildLeave, msg.build());
    }

    public void MoveToZone(long zoneId) {
        Zone.MoveToZone.Builder msg = Zone.MoveToZone.newBuilder();
        msg.setZoneId(zoneId);
        this.connection.send(Cmd.MoveToZone, msg.build());
    }

    public void AvatarActionAttack(long avatarId) {
        Zone.AvatarActionAttack.Builder msg = Zone.AvatarActionAttack.newBuilder();
        msg.setAvatarId(avatarId);
        this.connection.send(Cmd.AvatarActionAttack, msg.build());
    }

    public void TreasureActionDig(long treasureId) {
        Treasure.TreasureActionDig.Builder msg = Treasure.TreasureActionDig.newBuilder();
        msg.setId(treasureId);
        this.connection.send(Cmd.TreasureDig, msg.build());
    }

    public void TreasureActionStop(long treasureId) {
        Treasure.TreasureActionStop.Builder msg = Treasure.TreasureActionStop.newBuilder();
        msg.setId(treasureId);
        this.connection.send(Cmd.TreasureStop, msg.build());
    }

    public void GetGameRating() {
        Rating.GetGameRating.Builder msg = Rating.GetGameRating.newBuilder();
        this.connection.send(Cmd.GetGameRating, msg.build());
    }

    public void GetGiftList() {
        this.connection.send(Cmd.GiftList, null);
    }

    public void TakeGift(long giftId) {
        Gifts.TakeGift.Builder msg = Gifts.TakeGift.newBuilder();
        msg.setId(giftId);
        this.connection.send(Cmd.TakeGift, msg.build());
    }

    public void CreateUnit(long unitTypeId) {
        Unit.CreateUnit.Builder msg = Unit.CreateUnit.newBuilder();
        msg.setUnitTypeId(unitTypeId);
        this.connection.send(Cmd.CreateUnit, msg.build());
    }

    public void UnitActionUpgrade(long unitTypeId, boolean damage, boolean armor, boolean health) {
        Unit.UnitActionUpgrade.Builder msg = Unit.UnitActionUpgrade.newBuilder();
        msg.setUnitTypeId(unitTypeId);
        msg.setArmor(armor ? 1 : 0);
        msg.setDamage(damage ? 1 : 0);
        msg.setHealth(health ? 1 : 0);
        this.connection.send(Cmd.UnitActionUpgrade, msg.build());
    }

    public void AvatarCloseSession(long avatarId) {
        Avatars.AvatarCloseSession.Builder msg = Avatars.AvatarCloseSession.newBuilder();
        msg.setId(avatarId);
        this.connection.send(Cmd.CloseSession, msg.build());
    }

    public void ArtefactActionBuy(long artefactId, int count) {
        Artefact.ArtefactActionBuy.Builder msg = Artefact.ArtefactActionBuy.newBuilder();
        msg.setCount(count);
        msg.setTypeId(artefactId);
        this.connection.send(Cmd.ArtefactActionBuy, msg.build());
    }

    public void ArtefactActionBuySlot() {
        Artefact.ArtefactActionBuySlot.Builder msg = Artefact.ArtefactActionBuySlot.newBuilder();
        this.connection.send(Cmd.ArtefactActionBuySlot, msg.build());
    }

    public void ArtefactActionRemove(long artefactId) {
        Artefact.ArtefactActionRemove.Builder msg = Artefact.ArtefactActionRemove.newBuilder();
        msg.setArtefactId(artefactId);
        this.connection.send(Cmd.ArtefactActionRemove, msg.build());
    }

    public void BuyUnits() {
        this.connection.send(Cmd.BuyUnits, Unit.BuyUnits.newBuilder().build());
    }

    public void QuestTakeReward(long questId) {
        Quest.QuestTakeReward.Builder msg = Quest.QuestTakeReward.newBuilder();
        msg.setQuestId(questId);
        this.connection.send(Cmd.QuestTakeReward, msg.build());
    }

    public void QuestTake(long questId) {
        Quest.QuestTake.Builder msg = Quest.QuestTake.newBuilder();
        msg.setQuestId(questId);
        this.connection.send(Cmd.QuestTake, msg.build());
    }

    public void GetGuildTaskList() {
        this.connection.send(Cmd.GetGuildTaskList, Guild.GetGuildTaskList.newBuilder().build());
    }

    public void GetBattleChronicles() {
        this.connection.send(Cmd.GetBattleChronicles, Battle.GetBattleChronicles.newBuilder().build());
    }

    public void SendMessage(String name, String code, String text) {
        Message.AvatarMessage.Builder msg = Message.AvatarMessage.newBuilder();
        msg.setName(name);
        msg.setCode(code);
        msg.setText(text);
        this.connection.send(Cmd.SendMessage, msg.build());
    }

    public void ExchangeEnergyRequest(long positionId) {
        Exchanger.ExchangeEnergyRequest.Builder msg = Exchanger.ExchangeEnergyRequest.newBuilder();
        msg.setPositionId(positionId);
        this.connection.send(Cmd.ExchangeEnergyRequest, msg.build());
    }

    public void UnitTechActionSell(long unitTechId) {
        Unit.UnitTechActionSell.Builder msg = Unit.UnitTechActionSell.newBuilder();
        msg.setUnitTechId(unitTechId);
        this.connection.send(Cmd.UnitTechActionSell, msg.build());
    }

    public void UnitTechActionBuy(long unitTechTypeId) {
        Unit.UnitTechActionBuy.Builder msg = Unit.UnitTechActionBuy.newBuilder();
        msg.setUnitTechTypeId(unitTechTypeId);
        this.connection.send(Cmd.UnitTechActionBuy, msg.build());
    }

    public void GetClanData(long clanId) {
        Clan.GetClanData.Builder msg = Clan.GetClanData.newBuilder();
        msg.setId(clanId);
        this.connection.send(Cmd.GetClanData, msg.build());
    }

    public void GetClanList() {
        Clan.GetClanList.Builder msg = Clan.GetClanList.newBuilder();
        this.connection.send(Cmd.GetClanList, msg.build());
    }

    public void GetClanInvitationList() {
        Clan.GetClanInvitationList.Builder msg = Clan.GetClanInvitationList.newBuilder();
        this.connection.send(Cmd.GetClanInvitationList, msg.build());
    }

    public void GetClanApplicationList() {
        Clan.GetClanApplicationList.Builder msg = Clan.GetClanApplicationList.newBuilder();
        this.connection.send(Cmd.GetClanApplicationList, msg.build());
    }

    public void ClanActionSearch(String clanTag) {
        Clan.ClanActionSearch.Builder msg = Clan.ClanActionSearch.newBuilder();
        msg.setTag(clanTag);
        this.connection.send(Cmd.ClanActionSearch, msg.build());
    }

    public void ClanActionCreate(String tag, String name, int price, String slogan) {
        Clan.ClanActionCreate.Builder msg = Clan.ClanActionCreate.newBuilder();
        msg.setTag(tag);
        msg.setName(name);
        msg.setEnterPrice(price);
        msg.setDescription(slogan);
        this.connection.send(Cmd.ClanActionCreate, msg.build());
    }

    public void ClanChangeDescription(String text) {
        Clan.ClanChangeDescription.Builder msg = Clan.ClanChangeDescription.newBuilder();
        msg.setDescription(text);
        this.connection.send(Cmd.ClanChangeDescription, msg.build());
    }

    public void ClanChangeAutoApproval(boolean value) {
        Clan.ClanChangeAutoApproval.Builder msg = Clan.ClanChangeAutoApproval.newBuilder();
        msg.setAutoApproval(value);
        this.connection.send(Cmd.ClanChangeAutoApproval, msg.build());
    }

    public void ClanActionLeave(String name) {
        Clan.ClanActionLeave.Builder msg = Clan.ClanActionLeave.newBuilder();
        msg.setName(name);
        this.connection.send(Cmd.ClanActionLeave, msg.build());
    }

    public void ClanActionExclude(String name) {
        Clan.ClanActionExclude.Builder msg = Clan.ClanActionExclude.newBuilder();
        msg.setName(name);
        this.connection.send(Cmd.ClanActionExclude, msg.build());
    }

    public void ClanActionLeave() {
        Clan.ClanActionLeave.Builder msg = Clan.ClanActionLeave.newBuilder();
        this.connection.send(Cmd.ClanActionLeave, msg.build());
    }

    public void ClanActionTake(long avatarId) {
        Clan.ClanActionTake.Builder msg = Clan.ClanActionTake.newBuilder();
        msg.setAvatarId(avatarId);
        this.connection.send(Cmd.ClanActionTake, msg.build());
    }

    public void ClanDeleteApplication(long id) {
        Clan.ClanDeleteApplication.Builder msg = Clan.ClanDeleteApplication.newBuilder();
        msg.setApplicationId(id);
        this.connection.send(Cmd.ClanDeleteApplication, msg.build());
    }

    public void ClanDeleteInvitation(long id) {
        Clan.ClanDeleteInvitation.Builder msg = Clan.ClanDeleteInvitation.newBuilder();
        msg.setInviteId(id);
        this.connection.send(Cmd.ClanDeleteInvitation, msg.build());
    }

    public void ClanActionJoin(long clanId) {
        Clan.ClanActionJoin.Builder msg = Clan.ClanActionJoin.newBuilder();
        msg.setClanId(clanId);
        this.connection.send(Cmd.ClanActionJoin, msg.build());
    }

    public void ClanActionInvate(String name) {
        Clan.ClanActionInvite.Builder msg = Clan.ClanActionInvite.newBuilder();
        msg.setName(name);
        this.connection.send(Cmd.ClanActionInvite, msg.build());
    }

    public void ClanActionApplication(String tag) {
        Clan.ClanActionApply.Builder msg = Clan.ClanActionApply.newBuilder();
        msg.setTag(tag);
        this.connection.send(Cmd.ClanActionApplication, msg.build());
    }

    public void BattleActionEscape() {
        Battle.BattleActionEscape.Builder msg = Battle.BattleActionEscape.newBuilder();
        this.connection.send(Cmd.BattleActionEscape, msg.build());
    }

    public void BattleActionAttack(Battle.BattleActionAttack.Builder msg) {
        this.connection.send(Cmd.BattleActionAttack, msg.build());
    }

    public void BattleActionExit() {
        Battle.BattleActionExit.Builder msg = Battle.BattleActionExit.newBuilder();
        this.connection.send(Cmd.BattleActionExit, msg.build());
    }

    public void BattleActionJoin(long battleId) {
        Battle.BattleActionJoin.Builder msg = Battle.BattleActionJoin.newBuilder();
        msg.setId(battleId);
        this.connection.send(Cmd.BattleActionJoin, msg.build());
    }

    public void ChatActionLeave() {
        Chat.ChatActionLeave.Builder msg = Chat.ChatActionLeave.newBuilder();
        this.connection.send(Cmd.ChatActionLeave, msg.build());
    }

    public void ChatAvatarMessage(String message) {
        Chat.ChatAvatarMessage.Builder msg = Chat.ChatAvatarMessage.newBuilder();
        msg.setMessages(message);
        this.connection.send(Cmd.ChatSendMessage, msg.build());
    }

    public void ChatActionJoin(long chatTypeId) {
        Chat.ChatActionJoin.Builder msg = Chat.ChatActionJoin.newBuilder();
        msg.setChatTypeId(chatTypeId);
        this.connection.send(Cmd.ChatActionJoin, msg.build());
    }

    public void MineActionDig(long buildingId) {
        Building.MineActionDig.Builder msg = Building.MineActionDig.newBuilder();
        msg.setId(buildingId);
        this.connection.send(Cmd.MineDig, msg.build());
    }

    public void MineActionStop(long buildingId) {
        Building.MineActionStop.Builder msg = Building.MineActionStop.newBuilder();
        msg.setId(buildingId);
        this.connection.send(Cmd.MineStop, msg.build());
    }

    public void GateActionLiberate(long buildingId) {
        Building.GateActionLiberate.Builder msg = Building.GateActionLiberate.newBuilder();
        msg.setId(buildingId);
        this.connection.send(Cmd.GateActionLiberate, msg.build());
    }

    public void GateActionUsurp(long buildingId) {
        Building.GateActionUsurp.Builder msg = Building.GateActionUsurp.newBuilder();
        msg.setId(buildingId);
        this.connection.send(Cmd.GateActionUsurp, msg.build());
    }

    public void GateActionTeleport(long buildingId) {
        Building.GateActionTeleport.Builder msg = Building.GateActionTeleport.newBuilder();
        msg.setId(buildingId);
        this.connection.send(Cmd.GateActionTeleport, msg.build());
    }

    public void CitadelActionUsurp(long buildingId) {
        Building.CitadelActionUsurp.Builder msg = Building.CitadelActionUsurp.newBuilder();
        msg.setId(buildingId);
        this.connection.send(Cmd.CitadelActionUsurp, msg.build());
    }

    public void RemoveUnit(long unitId) {
        Unit.RemoveUnit.Builder msg = Unit.RemoveUnit.newBuilder();
        msg.setUnitId(unitId);
        this.connection.send(Cmd.RemoveUnit, msg.build());
    }

    public void GetArenaBattles() {
        this.connection.send(Cmd.ArenaBattleList, Arena.GetArenaBattles.newBuilder().build());
    }

    public void StartArenaBattle(Long planetId, Long zoneId, Integer type) {
        Arena.StartArenaBattle.Builder msg = Arena.StartArenaBattle.newBuilder();
        msg.setPlanetId(planetId);
        msg.setZoneId(zoneId);
        msg.setType(type);
        this.connection.send(Cmd.StartArenaBattle, msg.build());
    }

    public void RemoveArenaBattle() {
        this.connection.send(Cmd.RemoveArenaBattle, Arena.RemoveArenaBattle.newBuilder().build());
    }

    public static Commander getInstance() {
        return instance;
    }
}

