/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.net;

import com.badlogic.gdx.Gdx;
import com.google.protobuf.GeneratedMessage;
import com.tpwar.net.ClientChannelInitializer;
import com.tpwar.net.Cmd;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.Observable;
import packet.Transport;

public class Connection
extends Observable {
    private static final String TAG = Connection.class.getSimpleName();
    private static Connection instance;
    private final Bootstrap bootstrap;
    private final NioEventLoopGroup group = new NioEventLoopGroup(1);
    private Channel channel;

    public Connection() {
        this.bootstrap = new Bootstrap();
        this.bootstrap.group(this.group);
        this.bootstrap.channel(NioSocketChannel.class);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, true);
        this.bootstrap.option(ChannelOption.TCP_NODELAY, true);
        this.bootstrap.handler(new ClientChannelInitializer(this));
    }

    public void connect(String host, int port) {
        try {
            if (this.channel != null) {
                this.channel.close().sync();
                this.channel = null;
            }
        }
        catch (InterruptedException e) {
            Gdx.app.error(TAG, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f", e);
        }
        InetSocketAddress addr = new InetSocketAddress(host, port);
        ChannelFuture future = this.bootstrap.connect(addr);
        future.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    Connection.this.channel = future.channel();
                    Connection.this.notifyObservers(new ConnectionEvent());
                    Gdx.app.log(TAG, "Connected");
                } else {
                    Connection.this.notifyObservers(new NotConnectedEvent());
                    Gdx.app.error(TAG, "Not Connected");
                }
            }
        });
    }

    @Override
    public void notifyObservers(Object arg) {
        this.setChanged();
        super.notifyObservers(arg);
    }

    public void send(Cmd cmd, GeneratedMessage message) {
        if (this.isConnected()) {
            Transport.Packet.Builder transport = Transport.Packet.newBuilder();
            transport.setPing(false);
            transport.setTime(new Date().getTime());
            transport.setCmd(cmd.getCode());
            transport.setEncrypted(false);
            transport.setIdsess(1L);
            transport.setMsgnum(0L);
            if (message != null) {
                transport.setData(message.toByteString());
            }
            this.channel.writeAndFlush(transport.build());
        } else {
            Gdx.app.error(TAG, "Can't send message to inactive connection");
            this.notifyObservers(new ConnectionLostEvent());
        }
    }

    public boolean isConnected() {
        return this.channel != null && this.channel.isActive();
    }

    public void close() {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        if (this.group != null) {
            this.group.shutdownGracefully();
        }
    }

    public static Connection getInstance() {
        if (instance == null) {
            instance = new Connection();
        }
        return instance;
    }

    public static class ConnectionLostEvent {
    }

    public static class NotConnectedEvent {
    }

    public static class ConnectionEvent {
    }
}

