/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.net;

import com.tpwar.domain.avatar.ArtefactData;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.AvatarQuest;
import com.tpwar.domain.avatar.AvatarQuestGoal;
import com.tpwar.domain.avatar.BattleMarkData;
import com.tpwar.domain.avatar.BuildingInfoData;
import com.tpwar.domain.avatar.BuildingStatusData;
import com.tpwar.domain.avatar.EventData;
import com.tpwar.domain.avatar.HomePlanetStatusData;
import com.tpwar.domain.avatar.TaskBuildingInfoData;
import com.tpwar.domain.avatar.TreasureData;
import com.tpwar.domain.avatar.TreasureStatusData;
import com.tpwar.domain.avatar.UnitData;
import com.tpwar.domain.avatar.UnitTechData;
import com.tpwar.domain.avatar.UnitUpgradeData;
import com.tpwar.domain.player.PlayerGiftData;
import java.util.Date;
import packet.Artefact;
import packet.Avatars;
import packet.Building;
import packet.Event;
import packet.Fraction;
import packet.Gifts;
import packet.Guild;
import packet.Quest;
import packet.Treasure;
import packet.Unit;
import packet.Zone;

public class DataConverter {
    public static AvatarData fromAvatarDto(AvatarData avatar, Avatars.AvatarDto avatarDto) {
        avatar.id = avatarDto.getId();
        avatar.name = avatarDto.getName();
        avatar.fractionId = avatarDto.getFractionId();
        avatar.position = avatarDto.getPosition();
        avatar.level = avatarDto.getLevel();
        avatar.defeats = avatarDto.getDefeats();
        avatar.draws = avatarDto.getDraws();
        avatar.escape = avatarDto.getEscape();
        avatar.winsStreak = avatarDto.getWinStreak();
        avatar.wins = avatarDto.getWins();
        avatar.numUnits = avatarDto.getNumUnits();
        avatar.treasureId = avatarDto.hasTreasureId() ? avatarDto.getTreasureId() : 0L;
        avatar.guildId = avatarDto.hasGuildId() ? avatarDto.getGuildId() : 0L;
        avatar.guildRankId = avatarDto.hasGuildRankId() ? avatarDto.getGuildRankId() : 0L;
        avatar.experience = avatarDto.hasExperience() ? avatarDto.getExperience() : 0L;
        avatar.energy = avatarDto.hasEnergy() ? avatarDto.getEnergy() : 0;
        avatar.zoneId = avatarDto.hasZoneId() ? avatarDto.getZoneId() : 0L;
        avatar.planetId = avatarDto.hasPlanetId() ? avatarDto.getPlanetId() : 0L;
        avatar.availNumArtefact = avatarDto.hasAvailNumArtefact() ? avatarDto.getAvailNumArtefact() : 0;
        avatar.upgradePoints = avatarDto.hasUpgradePoints() ? avatarDto.getUpgradePoints() : 0;
        avatar.lastInvasionTime = avatarDto.hasLastInvasion() ? avatarDto.getLastInvasion() : 0L;
        avatar.flags = avatarDto.hasFlags() ? avatarDto.getFlags() : 0;
        avatar.pointReset = avatarDto.hasPointsReset() && avatarDto.getPointsReset();
        avatar.timeWarpTypeId = avatarDto.hasTimeWarpTypeId() ? avatarDto.getTimeWarpTypeId() : 0L;
        avatar.clanTag = avatarDto.hasClanTag() ? avatarDto.getClanTag() : "";
        avatar.clanId = avatarDto.hasClanId() ? avatarDto.getClanId() : 0L;
        avatar.maxLevel = avatarDto.hasMaxLevel() ? avatarDto.getMaxLevel() : 0;
        avatar.lastLogin = avatarDto.getLastLogin();
        avatar.shield = avatarDto.hasShield() ? avatarDto.getShield() : 0L;
        avatar.playerId = avatarDto.hasPlayerId() ? avatarDto.getPlayerId() : 0L;
        avatar.created = avatarDto.hasCreated() ? avatarDto.getCreated() : 0L;
        avatar.numBattlesInvasion = avatarDto.hasNumBattlesInvasion() ? avatarDto.getNumBattlesInvasion() : 0;
        avatar.gateBlockTime = avatarDto.hasGateBlockTime() ? avatarDto.getGateBlockTime() : 0L;
        return avatar;
    }

    public static BattleMarkData fromBattleMarkDto(Zone.BattleMarkDto battleMarkDto) {
        BattleMarkData bm = new BattleMarkData();
        bm.id = battleMarkDto.getId();
        bm.position = battleMarkDto.getPosition();
        bm.timeStart = new Date(battleMarkDto.getTimeStart());
        bm.avatar1 = DataConverter.fromAvatarDto(battleMarkDto.getAvatar1());
        bm.avatar2 = DataConverter.fromAvatarDto(battleMarkDto.getAvatar2());
        return bm;
    }

    public static AvatarData fromAvatarDto(Avatars.AvatarDto avatarDto) {
        return DataConverter.fromAvatarDto(new AvatarData(), avatarDto);
    }

    public static UnitData fromUnitDto(Unit.UnitDto unitDto) {
        UnitData unitData = new UnitData();
        unitData.id = unitDto.getId();
        unitData.isCreated = unitDto.getIsCreated();
        unitData.slot = unitDto.getSlot();
        unitData.startTime = unitDto.getStartTime();
        unitData.createTime = unitDto.getCreateTime();
        unitData.unitTypeId = unitDto.getUnitTypeId();
        unitData.isAlive = unitDto.getIsAlive();
        unitData.damage = unitDto.hasDamage() ? unitDto.getDamage() : 0;
        unitData.armor = unitDto.hasArmor() ? unitDto.getArmor() : 0;
        unitData.health = unitDto.hasHealth() ? unitDto.getHealth() : 0;
        unitData.defaultHealth = unitDto.hasDefaultHealth() ? unitDto.getDefaultHealth() : 0;
        unitData.isNew = unitDto.getIsNew();
        return unitData;
    }

    public static UnitTechData fromUnitTechDto(Unit.UnitTechDto unitTechDto) {
        return DataConverter.fromUnitTechDto(unitTechDto, null);
    }

    public static UnitTechData fromUnitTechDto(Unit.UnitTechDto unitTechDto, UnitTechData to) {
        UnitTechData unitTechData = to != null ? to : new UnitTechData();
        unitTechData.id = unitTechDto.getId();
        unitTechData.unitTechTypeId = unitTechDto.getUnitTechTypeId();
        return unitTechData;
    }

    public static TreasureData fromTreasureDto(Treasure.TreasureDto treasureDto) {
        TreasureData treasureData = new TreasureData();
        treasureData.id = treasureDto.getId();
        treasureData.avatarId = treasureDto.getAvatarId();
        treasureData.planetId = treasureDto.getPlanetId();
        treasureData.zoneId = treasureDto.getZoneId();
        treasureData.position = treasureDto.getPosition();
        treasureData.isNew = treasureDto.getIsNew();
        return treasureData;
    }

    public static TreasureStatusData fromTreasureStatusDto(Treasure.TreasureStatusDto statusDto) {
        TreasureStatusData tsd = new TreasureStatusData();
        tsd.status = statusDto.getStatus();
        tsd.timeout = statusDto.getTimeout();
        tsd.timeEnd = statusDto.getTimeEnd();
        return tsd;
    }

    public static UnitUpgradeData formUpgradeDto(Unit.UnitUpgradeDto upgradeDto) {
        UnitUpgradeData unitUpgrade = new UnitUpgradeData();
        unitUpgrade.unitTypeId = upgradeDto.getUnitTypeId();
        unitUpgrade.id = upgradeDto.getId();
        unitUpgrade.level = upgradeDto.getLevel();
        unitUpgrade.damage = upgradeDto.getDamage();
        unitUpgrade.armor = upgradeDto.getArmor();
        unitUpgrade.health = upgradeDto.getHealth();
        return unitUpgrade;
    }

    public static BuildingStatusData fromBuildingStatus(Building.BuildingStatus status) {
        BuildingStatusData bsd = new BuildingStatusData();
        bsd.id = status.getId();
        bsd.status = status.getStatus();
        bsd.timeout = status.getTimeout();
        bsd.timeEnd = status.getTimeEnd();
        return bsd;
    }

    public static BuildingInfoData fromBuildingInfoDto(Building.BuildingInfoDto buildingInfoDto) {
        BuildingInfoData bid = new BuildingInfoData();
        bid.buildingId = buildingInfoDto.getBuildingId();
        bid.lastUsedTime = buildingInfoDto.getLastUsedTime();
        return bid;
    }

    public static HomePlanetStatusData fromHomePlanetStatusDto(Fraction.HomePlanetStatusDto homePlanetStatusDto) {
        HomePlanetStatusData hpsd = new HomePlanetStatusData();
        hpsd.planetId = homePlanetStatusDto.getPlanetId();
        hpsd.gateOpen = homePlanetStatusDto.getGatesOpen();
        return hpsd;
    }

    public static EventData fromEventMessageDto(Event.EventMessageDto eventMessageDto) {
        EventData event = new EventData();
        event.value = eventMessageDto.getValue();
        event.code = eventMessageDto.getCode();
        event.fractionId = eventMessageDto.getFractionId();
        event.level = eventMessageDto.getLevel();
        event.name = eventMessageDto.getName();
        event.status = eventMessageDto.getStatus();
        return event;
    }

    public static ArtefactData fromArtefactDto(Artefact.ArtefactDto artefactDto) {
        ArtefactData artefactData = new ArtefactData();
        artefactData.id = artefactDto.getId();
        artefactData.artefactTypeId = artefactDto.getArtefactTypeId();
        artefactData.count = artefactDto.getCount();
        return artefactData;
    }

    public static TaskBuildingInfoData fromTaskBuildingInfoDto(Guild.TaskBuildingInfoDto taskBuildingInfoDto) {
        TaskBuildingInfoData data = new TaskBuildingInfoData();
        data.buildingId = taskBuildingInfoDto.getBuildingId();
        data.fractionId = taskBuildingInfoDto.getFractionId();
        data.level = taskBuildingInfoDto.getLevel();
        data.name = taskBuildingInfoDto.getName();
        return data;
    }

    public static AvatarQuest fromAvatarQuestDto(Quest.AvatarQuestDto questDto) {
        AvatarQuest quest = new AvatarQuest();
        quest.id = questDto.getId();
        quest.questTypeId = questDto.getQuestTypeId();
        quest.startTime = questDto.getStartTime();
        quest.endTime = questDto.getEndTime();
        quest.completed = questDto.getCompleted();
        quest.reward = questDto.getReward();
        quest.avatarId = questDto.getAvatarId();
        for (Quest.AvatarQuestGoalDto qg : questDto.getGoalsList()) {
            quest.goals.add(DataConverter.fromAvatarQuestGoalDto(qg));
        }
        return quest;
    }

    public static AvatarQuestGoal fromAvatarQuestGoalDto(Quest.AvatarQuestGoalDto qg) {
        AvatarQuestGoal goal = new AvatarQuestGoal();
        goal.id = qg.getId();
        goal.count = qg.getCount();
        goal.goalTypeId = qg.getGoalTypeId();
        goal.planetId = qg.getPlanetId();
        goal.name = qg.getName();
        goal.point = qg.getPoint();
        goal.questId = qg.getQuestId();
        return goal;
    }

    public static PlayerGiftData fromPlayerGiftDto(Gifts.PlayerGiftDto giftDto) {
        PlayerGiftData gift = new PlayerGiftData();
        gift.id = giftDto.getId();
        gift.giftTypeId = giftDto.getGiftTypeId();
        gift.received = giftDto.getReceived();
        gift.playerId = giftDto.getPlayerId();
        return gift;
    }
}

