/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.payment;

import com.badlogic.gdx.pay.Offer;
import com.badlogic.gdx.pay.OfferType;
import com.badlogic.gdx.pay.PurchaseManager;
import com.badlogic.gdx.pay.PurchaseManagerConfig;
import com.tpwar.payment.GamePurchaseObserver;
import com.tpwar.storage.Storage;
import com.tpwar.storage.bank.BankStorage;
import packet.Static;

public class Billing {
    private static final Billing INSTANCE = new Billing();
    private BankStorage bankStorage;
    private PurchaseManagerConfig config;
    private PurchaseManager manager;

    public Billing() {
        this.bankStorage = Storage.getInstance().bank;
        this.config = new PurchaseManagerConfig();
    }

    public void init(PurchaseManager manager) {
        this.manager = manager;
        for (Static.StaticBankPosition bankPosition : this.bankStorage.getAll()) {
            this.config.addOffer(new Offer().setType(OfferType.CONSUMABLE).setIdentifier(bankPosition.getItemId()));
        }
        manager.install(new GamePurchaseObserver(this), this.config, true);
    }

    public PurchaseManager getManager() {
        return this.manager;
    }

    public PurchaseManagerConfig getConfig() {
        return this.config;
    }

    public static Billing getInstance() {
        return INSTANCE;
    }
}

