/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.payment;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.pay.PurchaseObserver;
import com.badlogic.gdx.pay.Transaction;
import com.tpwar.domain.Model;
import com.tpwar.game.utils.LocalSettings;
import com.tpwar.net.Commander;
import com.tpwar.payment.Billing;
import com.tpwar.payment.PlayerTransaction;
import io.netty.util.internal.StringUtil;

public class GamePurchaseObserver
implements PurchaseObserver {
    private static final String TAG = GamePurchaseObserver.class.getSimpleName();
    private Commander commander = Commander.getInstance();
    private Model model = Model.getInstance();
    private LocalSettings settings = LocalSettings.getInstance();
    private Billing billing;

    public GamePurchaseObserver(Billing billing) {
        this.billing = billing;
    }

    @Override
    public void handleInstall() {
        Gdx.app.log(TAG, "handleInstall");
    }

    @Override
    public void handleInstallError(Throwable e) {
        Gdx.app.error(TAG, "handleInstallError: " + e.getMessage());
    }

    @Override
    public void handleRestore(Transaction[] transactions) {
        Gdx.app.log(TAG, "handleRestore");
        for (int i = 0; i < transactions.length; ++i) {
            this.handlePurchase(transactions[i]);
        }
    }

    @Override
    public void handleRestoreError(Throwable e) {
        Gdx.app.error(TAG, "handleRestoreError: " + e.getMessage());
    }

    @Override
    public void handlePurchase(final Transaction transaction) {
        if (StringUtil.isNullOrEmpty(transaction.getOrderId())) {
            Gdx.app.error(TAG, "handlePurchase orderId of transaction  is empty");
            return;
        }
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                GamePurchaseObserver.this.settings.saveTransaction(new PlayerTransaction(GamePurchaseObserver.this.model.player.id, transaction, false));
                GamePurchaseObserver.this.commander.sendTransaction(transaction);
            }
        });
    }

    @Override
    public void handlePurchaseError(Throwable e) {
        Gdx.app.error(TAG, "handlePurchaseError: " + e.getMessage());
        this.billing.getManager().purchaseRestore();
    }

    @Override
    public void handlePurchaseCanceled() {
        Gdx.app.error(TAG, "handlePurchaseCanceled");
    }
}

