/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.sound;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import com.tpwar.game.utils.LocalSettings;
import com.tpwar.sound.SoundPlayer;
import com.tpwar.sound.effects.MusicEffect;
import com.tpwar.sound.effects.VolumeFade;

public class DefaultMusicPlayer
implements SoundPlayer {
    private final LocalSettings settings = LocalSettings.getInstance();
    private float volumeDefault;
    private String currentLooping;
    private Array<Music> playing = new Array(8);
    private Pool<VolumeFade> pool = new Pool<VolumeFade>(8){

        @Override
        protected VolumeFade newObject() {
            return new VolumeFade();
        }
    };

    public DefaultMusicPlayer(float volumeDefault) {
        this.volumeDefault = volumeDefault;
    }

    @Override
    public void play(String name) {
        this.play(name, false);
    }

    @Override
    public void play(String name, boolean looping) {
        if (this.currentLooping != null && this.currentLooping == name) {
            return;
        }
        if (looping) {
            this.currentLooping = name;
        }
        if (!this.settings.music()) {
            return;
        }
        this.stop();
        Music music = Gdx.audio.newMusic(Gdx.files.internal(name));
        this.playing.add(music);
        music.setVolume(0.0f);
        music.play();
        music.setLooping(looping);
        music.setOnCompletionListener(new Music.OnCompletionListener(){

            @Override
            public void onCompletion(Music music) {
                music.dispose();
                DefaultMusicPlayer.this.playing.removeValue(music, true);
            }
        });
        this.pool.obtain().params(2000, this.volumeDefault).start(music, new MusicEffect.CompleteLitener(){

            @Override
            public void complete(MusicEffect effect, Music music) {
                DefaultMusicPlayer.this.pool.free((VolumeFade)effect);
            }
        });
    }

    @Override
    public void pause() {
        for (Music music : this.playing) {
            music.pause();
        }
    }

    @Override
    public void resume() {
        for (Music music : this.playing) {
            music.play();
        }
        if (this.playing.size == 0 && this.currentLooping != null) {
            String name = this.currentLooping;
            this.currentLooping = null;
            this.play(name, true);
        }
    }

    @Override
    public void stop() {
        for (Music music : this.playing) {
            this.pool.obtain().params(2000, 0.0f).start(music, new MusicEffect.CompleteLitener(){

                @Override
                public void complete(MusicEffect effect, Music music) {
                    music.stop();
                    music.dispose();
                    DefaultMusicPlayer.this.pool.free((VolumeFade)effect);
                }
            });
        }
        this.playing.clear();
    }

    @Override
    public void dispose() {
        this.stop();
    }
}

