/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.sound;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.utils.Array;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.LocalSettings;
import com.tpwar.sound.SoundPlayer;

public class DefaultSoundPlayer
implements SoundPlayer {
    private final LocalSettings settings = LocalSettings.getInstance();
    private final Assets assets = Assets.getInstance();
    private Array<Sound> playing = new Array(8);
    private float volumeDefault;

    public DefaultSoundPlayer(float volumeDefault) {
        this.volumeDefault = volumeDefault;
    }

    @Override
    public void play(String name) {
        this.play(name, false);
    }

    @Override
    public void play(String name, boolean looping) {
        if (!this.settings.sound()) {
            return;
        }
        Sound sound = (Sound)this.assets.get(name);
        long soundId = sound.play(this.volumeDefault);
        sound.setLooping(soundId, looping);
        this.playing.add(sound);
    }

    @Override
    public void pause() {
        for (Sound sound : this.playing) {
            sound.pause();
        }
    }

    @Override
    public void resume() {
        for (Sound sound : this.playing) {
            sound.resume();
        }
    }

    @Override
    public void stop() {
        for (Sound sound : this.playing) {
            sound.stop();
        }
    }

    @Override
    public void dispose() {
        this.stop();
    }
}

