/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.sound.effects;

import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Timer;
import com.tpwar.sound.effects.MusicEffect;

public class VolumeFade
implements MusicEffect,
Pool.Poolable {
    private int fadeTime;
    private float toValume;
    private float elapsed = 0.0f;
    private Music music;
    private MusicEffect.CompleteLitener listener;
    private float originalVolume;
    private float volume;

    public VolumeFade params(int fadeTime, float toValume) {
        this.fadeTime = fadeTime;
        this.toValume = toValume;
        return this;
    }

    @Override
    public void start(Music music, MusicEffect.CompleteLitener listener) {
        this.music = music;
        this.listener = listener;
        this.originalVolume = music.getVolume();
        this.elapsed = 0.0f;
        this.volume = this.originalVolume - this.toValume;
        Timer.schedule(new Timer.Task(){

            @Override
            public void run() {
                VolumeFade.this.update(100.0f);
            }
        }, 0.0f, 0.01f, this.fadeTime / 100 - 1);
    }

    @Override
    public void update(float dt) {
        this.elapsed += dt;
        float progress = this.elapsed / (float)this.fadeTime;
        float newValue = this.originalVolume - this.volume * progress;
        if (progress >= 1.0f) {
            this.music.setVolume(this.toValume);
            this.listener.complete(this, this.music);
        } else {
            this.music.setVolume(newValue);
        }
    }

    @Override
    public void reset() {
        this.fadeTime = 0;
        this.volume = 0.0f;
        this.elapsed = 0.0f;
        this.listener = null;
        this.toValume = 0.0f;
        this.originalVolume = 0.0f;
    }
}

