/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.storage;

import com.tpwar.storage.avatar.ArtefactTypeStorage;
import com.tpwar.storage.avatar.ChatTypeStorage;
import com.tpwar.storage.avatar.DailyBonusStorage;
import com.tpwar.storage.avatar.GiftTypeStorage;
import com.tpwar.storage.avatar.LevelStorage;
import com.tpwar.storage.avatar.TimeWarpTypeStorage;
import com.tpwar.storage.bank.BankStorage;
import com.tpwar.storage.bank.ExchangerStorage;
import com.tpwar.storage.building.BuildingStorage;
import com.tpwar.storage.building.BuildingTypeStorage;
import com.tpwar.storage.fraction.FractionStorage;
import com.tpwar.storage.guild.GuildRankStorage;
import com.tpwar.storage.guild.GuildStorage;
import com.tpwar.storage.guild.TaskTypeStorage;
import com.tpwar.storage.planet.PlanetStorage;
import com.tpwar.storage.planet.ZoneStorage;
import com.tpwar.storage.quest.QuestGoalTypeStorage;
import com.tpwar.storage.quest.QuestTypeStorage;
import com.tpwar.storage.shield.ItemTypeStorage;
import com.tpwar.storage.shield.ShieldTypeStorage;
import com.tpwar.storage.tutorial.TutorialStepStorage;
import com.tpwar.storage.tutorial.TutorialStorage;
import com.tpwar.storage.unit.TechTypeStorage;
import com.tpwar.storage.unit.UnitTypeStorage;
import packet.Static;

public class Storage {
    private static final Storage INSTANCE = new Storage();
    public final FractionStorage faction = new FractionStorage();
    public final BuildingTypeStorage buildingType = new BuildingTypeStorage();
    public final BuildingStorage building = new BuildingStorage();
    public final PlanetStorage planet = new PlanetStorage();
    public final ZoneStorage zone = new ZoneStorage();
    public final UnitTypeStorage unitType = new UnitTypeStorage();
    public final LevelStorage level = new LevelStorage();
    public final GuildStorage guild = new GuildStorage();
    public final TaskTypeStorage taskType = new TaskTypeStorage();
    public final ArtefactTypeStorage artefactType = new ArtefactTypeStorage();
    public final TechTypeStorage techType = new TechTypeStorage();
    public final GuildRankStorage guildRanks = new GuildRankStorage();
    public final BankStorage bank = new BankStorage();
    public final ChatTypeStorage chat = new ChatTypeStorage();
    public final ExchangerStorage exchanger = new ExchangerStorage();
    public final TutorialStorage tutorial = new TutorialStorage();
    public final TutorialStepStorage tutorialStep = new TutorialStepStorage();
    public final TimeWarpTypeStorage timeWarp = new TimeWarpTypeStorage();
    public final DailyBonusStorage bonus = new DailyBonusStorage();
    public final GiftTypeStorage giftTypes = new GiftTypeStorage();
    public final QuestTypeStorage questTypes = new QuestTypeStorage();
    public final QuestGoalTypeStorage questGoalTypes = new QuestGoalTypeStorage();
    public final ShieldTypeStorage shieldType = new ShieldTypeStorage();
    public final ItemTypeStorage itemType = new ItemTypeStorage();
    public Static.StaticWorldConfig worldConfig;

    private Storage() {
    }

    public void parse(Static.StaticContent content) {
        this.faction.parse(content.getFactionsList());
        this.buildingType.parse(content.getBuildingsTypesList());
        this.building.parse(content.getBuildingsList());
        this.planet.parse(content.getPlanetsList());
        this.zone.parse(content.getZonesList());
        this.unitType.parse(content.getUnitTypesList());
        this.level.parse(content.getLevelsList());
        this.taskType.parse(content.getTaskTypesList());
        this.techType.parse(content.getUnitTechList());
        this.guild.parse(content.getGuildsList());
        this.guildRanks.parse(content.getGuildRanksList());
        this.tutorial.parse(content.getTutorialsList());
        this.tutorialStep.parse(content.getTutorialStepsList());
        this.timeWarp.parse(content.getTimeWarpTypesList());
        this.bonus.parse(content.getDailyBonusesList());
        this.giftTypes.parse(content.getGiftTypesList());
        this.questTypes.parse(content.getQuestTypesList());
        this.questGoalTypes.parse(content.getQuestGoalTypesList());
        this.chat.parse(content.getChatTypesList());
        this.artefactType.parse(content.getArtefactTypesList());
        this.bank.parse(content.getBankPositionsList());
        this.exchanger.parse(content.getExchangerPositionsList());
        this.shieldType.parse(content.getShieldTypesList());
        this.itemType.parse(content.getItemTypesList());
        this.worldConfig = content.getWorldConfig();
    }

    public static Storage getInstance() {
        return INSTANCE;
    }
}

