/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.storage.avatar;

import com.tpwar.storage.DataStorage;
import java.util.List;
import packet.Static;

public class ChatTypeStorage
implements DataStorage<Static.StaticChatType> {
    public static final String GENERAL = "general";
    public static final String OSION = "osion";
    public static final String WAYLAND = "weyland";
    public static final String CLAN = "clan";
    public static final String ADMIN = "admin";
    private List<Static.StaticChatType> chtTypes;

    @Override
    public void parse(List<Static.StaticChatType> value) {
        this.chtTypes = value;
    }

    public Static.StaticChatType get(long id) {
        for (Static.StaticChatType ct : this.chtTypes) {
            if (ct.getId() != id) continue;
            return ct;
        }
        return null;
    }

    public Static.StaticChatType getChatTypeByCode(String code) {
        return this.getChatTypeByCode(code, 0L);
    }

    public Static.StaticChatType getChatTypeByCode(String code, long fractionId) {
        for (Static.StaticChatType chat : this.chtTypes) {
            if (!code.equals(chat.getCode()) || fractionId != 0L && chat.getFactionId() != fractionId) continue;
            return chat;
        }
        return null;
    }

    public Static.StaticChatType getGeneral() {
        return this.getChatTypeByCode(GENERAL);
    }

    public Static.StaticChatType getAdmin() {
        return this.getChatTypeByCode(ADMIN);
    }

    public Static.StaticChatType getFraction(Static.StaticFaction fraction) {
        String code = fraction.getCode().equals(OSION) ? OSION : WAYLAND;
        return this.getChatTypeByCode(code, fraction.getId());
    }

    public Static.StaticChatType getClan() {
        return this.getChatTypeByCode(CLAN);
    }

    public List<Static.StaticChatType> getAll() {
        return this.chtTypes;
    }
}

