/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.storage.building;

import com.tpwar.storage.DataStorage;
import com.tpwar.storage.Storage;
import com.tpwar.storage.planet.PlanetData;
import java.util.List;
import packet.Static;

public class BuildingStorage
implements DataStorage<Static.StaticBuilding> {
    public List<Static.StaticBuilding> buildings;

    @Override
    public void parse(List<Static.StaticBuilding> value) {
        this.buildings = value;
    }

    public Static.StaticBuilding get(long id) {
        for (Static.StaticBuilding b : this.buildings) {
            if (b.getId() != id) continue;
            return b;
        }
        return null;
    }

    public Static.StaticBuilding getByZoneId(long zoneId) {
        for (Static.StaticBuilding b : this.buildings) {
            if (b.getZoneId() != zoneId) continue;
            return b;
        }
        return null;
    }

    public int getNumBuilding(long planetId, String code) {
        int result = 0;
        Storage storage = Storage.getInstance();
        for (Static.StaticBuilding b : this.buildings) {
            Static.StaticBuildingType sbt = storage.buildingType.get(b.getBuildingTypeId());
            if (!sbt.getCode().equals(code)) continue;
            Static.StaticZone zone = storage.zone.get(b.getZoneId());
            PlanetData planet = storage.planet.get(zone.getPlanetId());
            if (planet.id != planetId) continue;
            ++result;
        }
        return result;
    }

    public List<Static.StaticBuilding> getAll() {
        return this.buildings;
    }
}

