/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.storage.fraction;

import com.badlogic.gdx.graphics.Color;
import com.tpwar.storage.DataStorage;
import java.util.ArrayList;
import java.util.List;
import packet.Static;

public class FractionStorage
implements DataStorage<Static.StaticFaction> {
    public static final int[] DEFENCE_ENERGY_REWARD = new int[]{2, 6, 8};
    public static final int[] INVADE_ENERGY_REWARD = new int[]{6, 10, 12};
    public static final String FACTION_OSION = "osion";
    public static final String FACTION_WEYLAND = "weyland";
    private static final String[] COLORS = new String[]{"#" + Color.CYAN, "#" + Color.valueOf("FF3300")};
    private static final String[] COLOR_FILTERS = new String[]{"#08486B", "#74160B"};
    private List<Static.StaticFaction> factions = new ArrayList<Static.StaticFaction>();

    @Override
    public void parse(List<Static.StaticFaction> value) {
        this.factions = value;
    }

    public Static.StaticFaction getWayland() {
        return this.getFactionByCode(FACTION_WEYLAND);
    }

    public Static.StaticFaction getOseon() {
        return this.getFactionByCode(FACTION_OSION);
    }

    public boolean isOseon(String code) {
        return FACTION_OSION.equals(code);
    }

    public boolean isWayland(String code) {
        return FACTION_WEYLAND.equals(code);
    }

    public String getColorFilter(long id) {
        Static.StaticFaction f = this.get(id);
        if (f == null) {
            return "#FFFFFF";
        }
        if (FACTION_OSION.equals(f.getCode())) {
            return COLOR_FILTERS[0];
        }
        return COLOR_FILTERS[1];
    }

    public Static.StaticFaction getFactionByCode(String code) {
        for (Static.StaticFaction f : this.factions) {
            if (!f.getCode().equals(code)) continue;
            return f;
        }
        return null;
    }

    public String getColor(long id) {
        Static.StaticFaction f = this.get(id);
        if (f == null) {
            return "#FFFFFF";
        }
        if (FACTION_OSION.equals(f.getCode())) {
            return COLORS[0];
        }
        return COLORS[1];
    }

    public Static.StaticFaction getOpposite(long id) {
        for (Static.StaticFaction f : this.factions) {
            if (f.getId() == id) continue;
            return f;
        }
        return null;
    }

    public Static.StaticFaction get(long id) {
        for (Static.StaticFaction f : this.factions) {
            if (f.getId() != id) continue;
            return f;
        }
        return null;
    }

    public List<Static.StaticFaction> getAll() {
        return this.factions;
    }
}

