/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.storage.guild;

import com.tpwar.storage.DataStorage;
import com.tpwar.storage.guild.TaskTypeData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import packet.Static;

public class GuildRankStorage
implements DataStorage<Static.StaticGuildRank> {
    private List<Static.StaticGuildRank> ranks;

    @Override
    public void parse(List<Static.StaticGuildRank> value) {
        this.ranks = value;
    }

    public List<Static.StaticGuildRank> getRanksByGuildId(long guildId) {
        ArrayList<Static.StaticGuildRank> list = new ArrayList<Static.StaticGuildRank>();
        for (Static.StaticGuildRank rank : this.ranks) {
            if (rank.getGuildId() != guildId) continue;
            list.add(rank);
        }
        return list;
    }

    public Static.StaticGuildRank getNextGuildRank(long guildId, int rank) {
        List<Static.StaticGuildRank> list = this.getRanksByGuildId(guildId);
        Collections.sort(list, new Comparator<Static.StaticGuildRank>(){

            @Override
            public int compare(Static.StaticGuildRank o1, Static.StaticGuildRank o2) {
                if (o1.getRank() < o2.getRank()) {
                    return -1;
                }
                if (o1.getRank() > o2.getRank()) {
                    return 1;
                }
                return 0;
            }
        });
        for (Static.StaticGuildRank r : list) {
            if (rank >= r.getRank()) continue;
            return r;
        }
        return null;
    }

    public Static.StaticGuildRank getRank(long guildId, int rank) {
        for (Static.StaticGuildRank r : this.ranks) {
            if (r.getGuildId() != guildId || r.getRank() != rank) continue;
            return r;
        }
        return null;
    }

    public Static.StaticGuildRank get(long id) {
        for (Static.StaticGuildRank r : this.ranks) {
            if (r.getId() != id) continue;
            return r;
        }
        return null;
    }

    public Static.StaticGuildRank getRankByScore(long guildId, int score) {
        Static.StaticGuildRank result = null;
        for (Static.StaticGuildRank r : this.ranks) {
            if (r.getGuildId() != guildId || r.getRequiredNumScoreTask() > score || result != null && result.getRequiredNumScoreTask() >= r.getRequiredNumScoreTask()) continue;
            result = r;
        }
        return result;
    }

    public String getModif(TaskTypeData taskType, Static.StaticGuildRank rank) {
        int modifier = rank.getModifier();
        switch (taskType.data.getCode()) {
            case "mine": {
                return "-" + (10 - modifier) + " \u043c\u0438\u043d";
            }
            case "hunting": {
                return "-" + (10 - modifier) + " \u043c\u0438\u043d";
            }
            case "invade": {
                return "+" + modifier + " \u044d\u043d";
            }
            case "defense": {
                return "+" + modifier + " \u044d\u043d";
            }
            case "devastation": {
                return modifier + " \u0447";
            }
        }
        return "";
    }
}

