/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.storage.guild;

import com.tpwar.storage.DataStorage;
import java.util.List;
import packet.Static;

public class GuildStorage
implements DataStorage<Static.StaticGuild> {
    private List<Static.StaticGuild> guilds;

    @Override
    public void parse(List<Static.StaticGuild> value) {
        this.guilds = value;
    }

    public int calcEntryPrice(Static.StaticGuild guild, int level) {
        if (level < guild.getMinLevel()) {
            level = guild.getMinLevel();
        }
        return guild.getEntryPriceEnergy() * (level + 1 - guild.getMinLevel());
    }

    public Static.StaticGuild getGuildByTaskId(long taskId) {
        for (Static.StaticGuild guild : this.guilds) {
            if (guild.getTaskTypeId() != taskId) continue;
            return guild;
        }
        return null;
    }

    public Static.StaticGuild getGuild(long id) {
        for (Static.StaticGuild guild : this.guilds) {
            if (guild.getId() != id) continue;
            return guild;
        }
        return null;
    }

    public static int getGuildRankFrame(Static.StaticGuildRank rank) {
        return (int)rank.getGuildId() * 5 - (6 - rank.getRank());
    }

    public List<Static.StaticGuild> getAll() {
        return this.guilds;
    }
}

