/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.storage.planet;

import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.storage.DataStorage;
import com.tpwar.storage.Storage;
import com.tpwar.storage.guild.TaskTypeData;
import com.tpwar.storage.planet.PlanetData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import packet.Static;

public class PlanetStorage
implements DataStorage<Static.StaticPlanet> {
    public static final int FLAG_TREASURE_PLANET = 1;
    public static final int FLAG_HOME_PLANET_FRACTION = 2;
    public static final int FLAG_GATE_PLANET = 4;
    private List<PlanetData> planets = new ArrayList<PlanetData>();

    @Override
    public void parse(List<Static.StaticPlanet> value) {
        this.planets.clear();
        for (Static.StaticPlanet sp : value) {
            PlanetData pd = new PlanetData();
            pd.id = sp.getId();
            pd.guildId = sp.getGuildId();
            pd.maxLevel = sp.getMaxLevel();
            pd.minLevel = sp.getMinLevel();
            pd.description = sp.getDescription();
            pd.factionId = sp.getFactionId();
            pd.guildMaxLevel = sp.getGuildMaxLevel();
            pd.name = sp.getName();
            pd.needWinStreak = sp.getNeedWinStreak();
            pd.flags = sp.getFlags();
            this.planets.add(pd);
        }
        Collections.sort(this.planets, new Comparator<PlanetData>(){

            @Override
            public int compare(PlanetData p1, PlanetData p2) {
                return (int)(p1.id - p2.id);
            }
        });
    }

    public boolean isHomePlanet(PlanetData p) {
        return (p.flags & 2) != 0;
    }

    public boolean isTreasurePlanet(PlanetData p) {
        return (p.flags & 1) != 0;
    }

    public boolean isGatePlanet(PlanetData p) {
        return (p.flags & 4) != 0;
    }

    public boolean isEris(PlanetData p) {
        return p.minLevel == 0 && p.maxLevel == 0 && p.flags == 0 && p.factionId == 0L;
    }

    public PlanetData getRandomAvailPlanet(AvatarData avatar) {
        List<PlanetData> availablePlanets = this.getAvailablePlanets(avatar);
        return availablePlanets.get(new Random().nextInt(availablePlanets.size()));
    }

    public List<PlanetData> getAvailablePlanets(AvatarData avatar) {
        Storage storage = Storage.getInstance();
        Static.StaticGuild guild = storage.guild.getGuild(avatar.guildId);
        TaskTypeData taskType = this.getByGuild(guild);
        boolean fractionUsurp = Model.getInstance().player.selectedAvatar.worldStatus.fractionIsOccupied(avatar.fractionId);
        return this.getAvailablePlanets(avatar, guild, taskType, fractionUsurp);
    }

    public List<PlanetData> getAvailablePlanets(AvatarData avatar, Static.StaticGuild guild, TaskTypeData taskType, boolean fractionUsurp) {
        ArrayList<PlanetData> result = new ArrayList<PlanetData>();
        for (PlanetData planet : this.planets) {
            if (!this.planetIsAvail(planet, avatar, guild, taskType, fractionUsurp)) continue;
            result.add(planet);
        }
        return result;
    }

    public boolean planetIsAvail(PlanetData planet, AvatarData avatar) {
        Storage storage = Storage.getInstance();
        Static.StaticGuild guild = storage.guild.getGuild(avatar.guildId);
        TaskTypeData taskType = this.getByGuild(guild);
        boolean fractionUsurp = Model.getInstance().player.selectedAvatar.worldStatus.fractionIsOccupied(avatar.fractionId);
        return this.planetIsAvail(planet, avatar, guild, taskType, fractionUsurp);
    }

    public boolean planetIsAvail(PlanetData planet, AvatarData avatar, Static.StaticGuild guild, TaskTypeData taskType, boolean fractionUsurp) {
        if (avatar.level < planet.minLevel) {
            return false;
        }
        if (!this.checkMinePlanet(planet, avatar, guild, taskType, fractionUsurp) || !this.checkGatePlanet(planet, avatar, guild, taskType, fractionUsurp)) {
            return false;
        }
        if (planet.guildId == 0L && !this.isGatePlanet(planet) && planet.maxLevel != 0 && avatar.level > planet.maxLevel) {
            return false;
        }
        if (this.isTreasurePlanet(planet) && (avatar.winsStreak < planet.needWinStreak && avatar.treasureId == 0L && (guild == null || !taskType.isTreasureHunter()) || fractionUsurp && !avatar.shieldIsActive())) {
            return false;
        }
        return !this.isHomePlanet(planet) || avatar.fractionId == planet.factionId;
    }

    private boolean checkMinePlanet(PlanetData planet, AvatarData avatar, Static.StaticGuild guild, TaskTypeData taskType, boolean fractionUsurp) {
        if (planet.guildId > 0L) {
            if (fractionUsurp) {
                if (guild != null && taskType.isMine()) {
                    return this.checkMaxLevel(avatar.level, planet.guildMaxLevel);
                }
                return false;
            }
            if (guild != null && taskType.isMine()) {
                return this.checkMaxLevel(avatar.level, planet.guildMaxLevel);
            }
            return this.checkMaxLevel(avatar.level, planet.maxLevel);
        }
        return true;
    }

    private boolean checkGatePlanet(PlanetData planet, AvatarData avatar, Static.StaticGuild guild, TaskTypeData taskType, boolean fractionUsurp) {
        if (this.isGatePlanet(planet)) {
            boolean isFractionGate;
            boolean bl = isFractionGate = planet.factionId == avatar.fractionId;
            if (guild != null) {
                if (isFractionGate) {
                    if (taskType.isDefence() || taskType.isDevastation()) {
                        return this.checkMaxLevel(avatar.level, planet.guildMaxLevel);
                    }
                    return this.checkMaxLevel(avatar.level, planet.maxLevel);
                }
                if (!fractionUsurp) {
                    if (taskType.isInvade() || taskType.isDevastation()) {
                        return this.checkMaxLevel(avatar.level, planet.guildMaxLevel);
                    }
                    return this.checkMaxLevel(avatar.level, planet.maxLevel);
                }
                return false;
            }
            if (isFractionGate) {
                return this.checkMaxLevel(avatar.level, planet.maxLevel);
            }
            return this.checkMaxLevel(avatar.level, planet.maxLevel) && !fractionUsurp;
        }
        return true;
    }

    private boolean checkMaxLevel(int avatarLevel, int planetMaxLevel) {
        return planetMaxLevel == 0 || planetMaxLevel > 0 && avatarLevel <= planetMaxLevel;
    }

    public PlanetData get(long id) {
        for (PlanetData p : this.planets) {
            if (p.id != id) continue;
            return p;
        }
        return null;
    }

    public int getIndexGatePlanet(long planetId, long fractionId) {
        int index = 0;
        for (PlanetData p : this.planets) {
            if (p.factionId != fractionId || !this.isGatePlanet(p)) continue;
            if (p.id == planetId) break;
            ++index;
        }
        return index;
    }

    private TaskTypeData getByGuild(Static.StaticGuild guild) {
        Storage storage = Storage.getInstance();
        if (guild != null) {
            return storage.taskType.get(guild.getTaskTypeId());
        }
        return null;
    }

    public List<PlanetData> getAllWithSort(final AvatarData avatar) {
        Storage storage = Storage.getInstance();
        final Static.StaticGuild guild = storage.guild.getGuild(avatar.guildId);
        final TaskTypeData taskType = this.getByGuild(guild);
        final boolean fractionUsurp = Model.getInstance().player.selectedAvatar.worldStatus.fractionIsOccupied(avatar.fractionId);
        ArrayList<PlanetData> result = new ArrayList<PlanetData>(this.planets.size() - 1);
        for (PlanetData planet : this.planets) {
            if (this.isHomePlanet(planet) && planet.factionId != avatar.fractionId) continue;
            result.add(planet);
        }
        Collections.sort(result, new Comparator<PlanetData>(){

            @Override
            public int compare(PlanetData o1, PlanetData o2) {
                boolean p1 = PlanetStorage.this.planetIsAvail(o1, avatar, guild, taskType, fractionUsurp);
                boolean p2 = PlanetStorage.this.planetIsAvail(o2, avatar, guild, taskType, fractionUsurp);
                if (p1 && !p2) {
                    return -1;
                }
                if (p2 && !p1) {
                    return 1;
                }
                if (o1.id > o2.id) {
                    return 1;
                }
                if (o1.id < o2.id) {
                    return -1;
                }
                return 0;
            }
        });
        return result;
    }
}

