/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.storage.planet;

import com.tpwar.storage.DataStorage;
import com.tpwar.storage.planet.PlanetData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import packet.Static;

public class ZoneStorage
implements DataStorage<Static.StaticZone> {
    private List<Static.StaticZone> zones;

    @Override
    public void parse(List<Static.StaticZone> value) {
        this.zones = new ArrayList<Static.StaticZone>(value);
        Collections.sort(this.zones, new ZoneComparator());
    }

    public String getPath(Static.StaticZone z) {
        return "maps/" + z.getMapFileName() + ".tpmap";
    }

    public Static.StaticZone get(long id) {
        for (Static.StaticZone z : this.zones) {
            if (z.getId() != id) continue;
            return z;
        }
        return null;
    }

    public int getSizePlanet(long planetId) {
        int result = 0;
        for (Static.StaticZone z : this.zones) {
            if (z.getPlanetId() != planetId) continue;
            ++result;
        }
        return result;
    }

    public List<Static.StaticZone> getZonesByPlanet(long planetId) {
        ArrayList<Static.StaticZone> result = new ArrayList<Static.StaticZone>();
        for (Static.StaticZone z : this.zones) {
            if (z.getPlanetId() != planetId) continue;
            result.add(z);
        }
        return result;
    }

    public Static.StaticZone getLeftZone(long planetId, long zoneId) {
        List<Static.StaticZone> list = this.getZonesByPlanet(planetId);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getId() != zoneId) continue;
            if (i == 0) {
                return list.get(list.size() - 1);
            }
            return list.get(i - 1);
        }
        return null;
    }

    public Static.StaticZone getRightZone(long planetId, long zoneId) {
        List<Static.StaticZone> list = this.getZonesByPlanet(planetId);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getId() != zoneId) continue;
            if (i == list.size() - 1) {
                return list.get(0);
            }
            return list.get(i + 1);
        }
        return null;
    }

    public Static.StaticZone getRandomZome(PlanetData planet) {
        List<Static.StaticZone> zones = this.getZonesByPlanet(planet.id);
        return zones.get(new Random().nextInt(zones.size()));
    }

    public List<Static.StaticZone> getZones() {
        return this.zones;
    }

    public List<Static.StaticZone> getAll() {
        return this.zones;
    }

    public static class ZoneComparator
    implements Comparator<Static.StaticZone> {
        @Override
        public int compare(Static.StaticZone staticZone, Static.StaticZone t1) {
            if (staticZone.getPosition() < t1.getPosition()) {
                return -1;
            }
            if (staticZone.getPosition() > t1.getPosition()) {
                return 1;
            }
            return 0;
        }
    }
}

