/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.storage.quest;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.tpwar.storage.DataStorage;
import java.util.List;
import packet.Static;

public class QuestGoalTypeStorage
implements DataStorage<Static.StaticQuestGoalType> {
    public static final String KILL_AVATAR = "kill_avatar";
    public static final String MINE = "mine";
    public static final String DEFENCE = "defence";
    public static final String INVADE = "invide";
    public static final String DEVASTATION = "devastation";
    public static final String TREASURE_MAP = "treasure_map";
    public static final String TREASURE = "treasure";
    private List<Static.StaticQuestGoalType> goalTypes;

    @Override
    public void parse(List<Static.StaticQuestGoalType> value) {
        this.goalTypes = value;
    }

    public ObjectMap<String, Static.StaticQuestType> composeQuestListByGoalType(Array<Static.StaticQuestType> questTypes) {
        ObjectMap<String, Static.StaticQuestType> result = new ObjectMap<String, Static.StaticQuestType>();
        for (Static.StaticQuestType qt : questTypes) {
            Array<Static.StaticQuestGoalType> goals = this.getGoalsByQuestTypeId(qt.getId());
            result.put(goals.first().getCode(), qt);
        }
        return result;
    }

    public Array<Static.StaticQuestGoalType> getGoalsByQuestTypeId(long questTypeId) {
        Array<Static.StaticQuestGoalType> result = new Array<Static.StaticQuestGoalType>();
        for (Static.StaticQuestGoalType qgt : this.goalTypes) {
            if (qgt.getQuestTypeId() != questTypeId) continue;
            result.add(qgt);
        }
        return result;
    }

    public Static.StaticQuestGoalType get(long id) {
        for (Static.StaticQuestGoalType qgt : this.goalTypes) {
            if (qgt.getId() != id) continue;
            return qgt;
        }
        return null;
    }

    public List<Static.StaticQuestGoalType> getAll() {
        return this.goalTypes;
    }
}

