/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.storage.tutorial;

import com.badlogic.gdx.utils.Array;
import com.tpwar.storage.DataStorage;
import com.tpwar.storage.tutorial.TutorialStepData;
import java.util.List;
import packet.Static;

public class TutorialStepStorage
implements DataStorage<Static.StaticTutorialStep> {
    private Array<TutorialStepData> tutorialSteps;

    @Override
    public void parse(List<Static.StaticTutorialStep> value) {
        this.tutorialSteps = new Array(value.size());
        for (Static.StaticTutorialStep sts : value) {
            TutorialStepData tsd = new TutorialStepData();
            tsd.id = sts.getId();
            tsd.name = sts.getName();
            tsd.step = sts.getStep();
            tsd.flags = sts.getFlags();
            tsd.tutorialId = sts.getTutorialId();
            this.tutorialSteps.add(tsd);
        }
    }

    public TutorialStepData getNextTutorialStep(long tutorialId, long stepId) {
        for (int i = 0; i < this.tutorialSteps.size; ++i) {
            TutorialStepData step = this.tutorialSteps.get(i);
            if (step.tutorialId != tutorialId || step.id != stepId) continue;
            if (i + 1 >= this.tutorialSteps.size || this.tutorialSteps.get((int)(i + 1)).tutorialId != tutorialId) break;
            return this.tutorialSteps.get(i + 1);
        }
        return null;
    }

    public TutorialStepData get(long id) {
        for (TutorialStepData ts : this.tutorialSteps) {
            if (ts.id != id) continue;
            return ts;
        }
        return null;
    }

    public Array<TutorialStepData> getAll() {
        return this.tutorialSteps;
    }
}

