/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.storage.unit;

import com.tpwar.storage.DataStorage;
import java.util.ArrayList;
import java.util.List;
import packet.Static;

public class TechTypeStorage
implements DataStorage<Static.StaticUnitTech> {
    private List<Static.StaticUnitTech> techTypes;

    @Override
    public void parse(List<Static.StaticUnitTech> value) {
        this.techTypes = value;
    }

    public Static.StaticUnitTech get(long id) {
        for (Static.StaticUnitTech ut : this.techTypes) {
            if (ut.getId() != id) continue;
            return ut;
        }
        return null;
    }

    public List<Static.StaticUnitTech> getAvailTechList(long unitTypeId, int paramType) {
        ArrayList<Static.StaticUnitTech> result = new ArrayList<Static.StaticUnitTech>();
        for (Static.StaticUnitTech tech : this.techTypes) {
            if (tech.getUnitTypeId() != unitTypeId || tech.getParamType() != paramType) continue;
            result.add(tech);
        }
        return result;
    }

    public List<Static.StaticUnitTech> getAvailTechList(long unitTypeId, boolean attack, boolean defence, boolean health) {
        ArrayList<Static.StaticUnitTech> result = new ArrayList<Static.StaticUnitTech>();
        for (Static.StaticUnitTech tech : this.techTypes) {
            if (tech.getUnitTypeId() != unitTypeId || !(attack && tech.getDamage() > 0 || defence && tech.getArmor() > 0) && (!health || tech.getHealth() <= 0)) continue;
            result.add(tech);
        }
        return result;
    }

    public List<Static.StaticUnitTech> getAll() {
        return this.techTypes;
    }
}

