/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.storage.unit;

import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.UnitTechData;
import com.tpwar.domain.avatar.UnitUpgradeData;
import com.tpwar.storage.DataStorage;
import com.tpwar.storage.Storage;
import com.tpwar.storage.unit.UnitTypeData;
import java.util.List;
import packet.Static;

public class UnitTypeStorage
implements DataStorage<Static.StaticUnitType> {
    private Array<UnitTypeData> unitTypes = new Array();

    @Override
    public void parse(List<Static.StaticUnitType> value) {
        this.unitTypes.clear();
        for (Static.StaticUnitType sut : value) {
            UnitTypeData ut = new UnitTypeData();
            ut.id = sut.getId();
            ut.code = sut.getCode();
            ut.description = sut.getDescription();
            ut.damage = sut.getDamage();
            ut.armor = sut.getArmor();
            ut.health = sut.getHealth();
            ut.limit = sut.getLimit();
            ut.minLevel = sut.getMinLevel();
            ut.name = sut.getName();
            ut.timeout = sut.getTimeout();
            this.unitTypes.add(ut);
        }
    }

    public void calcFullParameters(AvatarData avatar) {
        for (UnitTypeData unitType : this.unitTypes) {
            unitType.fullDamage = unitType.damage;
            unitType.fullArmor = unitType.armor;
            unitType.fullHealth = unitType.health;
            Array<UnitTechData> unitTechs = avatar.unitTechs;
            for (UnitTechData tech : unitTechs) {
                Static.StaticUnitTech type = Storage.getInstance().techType.get(tech.unitTechTypeId);
                if (type.getUnitTypeId() != 0L && type.getUnitTypeId() != unitType.id) continue;
                unitType.fullDamage += type.getDamage();
                unitType.fullArmor += type.getArmor();
                unitType.fullHealth += type.getHealth();
            }
            Array<UnitUpgradeData> upgrades = avatar.upgrades;
            for (UnitUpgradeData upgrade : upgrades) {
                if (upgrade.unitTypeId != unitType.id) continue;
                unitType.fullDamage += upgrade.damage;
                unitType.fullArmor += upgrade.armor;
                unitType.fullHealth += upgrade.health;
            }
        }
    }

    public int getTimeout(int timeout, int scale) {
        float temp = (float)timeout / 60.0f * (float)scale / 100.0f;
        return (int)((long)timeout - Math.round(temp < 0.0f ? -Math.ceil(Math.abs(temp)) : Math.ceil(temp)) * 60L);
    }

    public UnitTypeData getUnitTypeByCode(String code) {
        for (UnitTypeData ut : this.unitTypes) {
            if (!ut.code.equals(code)) continue;
            return ut;
        }
        return null;
    }

    public UnitTypeData get(long id) {
        for (UnitTypeData ut : this.unitTypes) {
            if (ut.id != id) continue;
            return ut;
        }
        return null;
    }

    public Array<UnitTypeData> getAll() {
        return this.unitTypes;
    }
}

