/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.tutorial;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.AvatarTutorialData;
import com.tpwar.domain.avatar.UnitData;
import com.tpwar.events.EventListener;
import com.tpwar.game.maps.TutorialPoint;
import com.tpwar.game.maps.buildings.Building;
import com.tpwar.game.screens.MapScreen;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.GameWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.barrack.BarrackWindow;
import com.tpwar.game.windows.barrack.UnitSlot;
import com.tpwar.game.windows.tutorial.TutorialWindow;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import com.tpwar.storage.Storage;
import com.tpwar.storage.tutorial.TutorialData;
import com.tpwar.storage.tutorial.TutorialStepData;
import com.tpwar.storage.unit.UnitTypeData;
import packet.Transport;

public class ArmyTutorial
extends InputAdapter
implements Disposable,
MessageListener {
    private final WindowManager windowManager = WindowManager.getInstance();
    private final Model model = Model.getInstance();
    private final Storage storage = Storage.getInstance();
    private final Array<Actor> targets = new Array();
    private final MapScreen screen;
    private BarrackWindow barrackWindow;
    private Vector3 point = new Vector3();
    private TutorialPoint tutorialPoint;
    private EventListener<GameWindow> windowOpenedListener;
    private boolean clickDownOnTarget;

    public ArmyTutorial(MapScreen screen) {
        this.screen = screen;
        this.tutorialPoint = new TutorialPoint();
        this.windowOpenedListener = new EventListener<GameWindow>(){

            @Override
            public void onEvent(int type, GameWindow window) {
                if (window instanceof BarrackWindow) {
                    ArmyTutorial.this.barrackWindow = (BarrackWindow)window;
                    ArmyTutorial.this.barrackWindow.addListener(new BarrackWindow.ChangeUnitSlotListener(){

                        @Override
                        public void changed(BarrackWindow.ChangeUnitSlotListener.ChangeUnitSlotEvent event, Actor actor) {
                            ArmyTutorial.this.nextStep();
                            ArmyTutorial.this.barrackWindow.removeListener(this);
                        }
                    });
                    ArmyTutorial.this.nextStep();
                } else if (window instanceof WarningWindow) {
                    WarningWindow msgWin = (WarningWindow)window;
                    ArmyTutorial.this.targets.add(msgWin.getActionButton());
                    ArmyTutorial.this.nextStep();
                }
            }
        };
        this.windowManager.addListener(1, this.windowOpenedListener);
        this.model.addListener(this, Cmd.UpdateUnits.getCode());
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        if (this.getCurrentTarget() == null) {
            this.nextStep();
        }
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (this.windowManager.hasOpenedWindowByClass(TutorialWindow.class)) {
            return false;
        }
        Actor target = (Actor)this.getCurrentTarget();
        boolean bl = this.clickDownOnTarget = target != null && target.getStage() != null && this.checkClickOnTarget(target, screenX, screenY);
        return !this.clickDownOnTarget;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        boolean clickOnTarget;
        Actor target = (Actor)this.getCurrentTarget();
        boolean bl = clickOnTarget = this.clickDownOnTarget && target != null && target.getStage() != null && this.checkClickOnTarget(target, screenX, screenY);
        if (!clickOnTarget && !this.windowManager.hasOpenedWindow()) {
            return true;
        }
        if (clickOnTarget) {
            this.targets.removeIndex(0);
            if (target instanceof Building) {
                ((Building)target).action();
            }
            if (this.targets.size == 0) {
                this.hidePointer();
                AvatarTutorialData tutorial = this.model.player.selectedAvatar.getCurrentTutorial();
                TutorialStepData tutorialStep = this.storage.tutorialStep.get(tutorial.tutorialStepId);
                if (tutorialStep.isFinishStep()) {
                    tutorial.completed = true;
                    this.removeTutorial();
                }
            } else {
                this.showPoint(this.getCurrentTarget());
            }
        } else {
            try {
                this.showPoint(this.getCurrentTarget());
            }
            catch (Exception e) {
                Gdx.app.log("", e.toString());
            }
        }
        return false;
    }

    private boolean checkClickOnTarget(Actor target, int screenX, int screenY) {
        boolean clickOnTarget = false;
        if (target instanceof Actor) {
            target.getStage().getViewport().unproject(this.point.set(screenX, screenY, 0.0f));
            Actor hitActor = target.getStage().hit(this.point.x, this.point.y, true);
            boolean bl = clickOnTarget = hitActor == target;
            if (!clickOnTarget) {
                Vector2 stageCoords = new Vector2(screenX, screenY);
                target.getParent().screenToLocalCoordinates(stageCoords);
                clickOnTarget = target.hit(stageCoords.x, stageCoords.y, true) != null;
            }
        }
        return clickOnTarget;
    }

    private void showPoint(Object target) {
        this.hidePointer();
        Actor actor = (Actor)target;
        float centerX = (actor.getWidth() - this.tutorialPoint.getWidth()) / 2.0f;
        float centerY = (actor.getHeight() - this.tutorialPoint.getHeight()) / 2.0f;
        Vector2 temp = new Vector2(centerX, centerY);
        actor.localToStageCoordinates(temp);
        actor.getStage().addActor(this.tutorialPoint);
        this.tutorialPoint.setPosition(temp.x, temp.y);
        this.tutorialPoint.play();
    }

    private void showHint(String hintText) {
        final TutorialWindow wnd = new TutorialWindow(Assets.getInstance().getDefaultSkin(), hintText);
        wnd.getCloseButton().addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                ArmyTutorial.this.hideHint();
                wnd.closeHandler();
            }
        });
        this.windowManager.open(wnd, true);
    }

    private void removeTutorial() {
        this.screen.removeTutorial();
    }

    private void hideHint() {
        if (this.getCurrentTarget() != null) {
            this.showPoint(this.getCurrentTarget());
        }
    }

    private void hidePointer() {
        this.screen.getMap().removeEntity(this.tutorialPoint);
        this.tutorialPoint.remove();
    }

    private Object getCurrentTarget() {
        return this.targets.size > 0 ? this.targets.get(0) : null;
    }

    public void nextStep() {
        AvatarTutorialData tutorial = this.model.player.selectedAvatar.getCurrentTutorial();
        TutorialData tutorialData = this.storage.tutorial.get(tutorial.tutorialId);
        if (!tutorialData.isArmyTutorial()) {
            this.removeTutorial();
            return;
        }
        if (tutorial.completed) {
            Gdx.app.log(this.getClass().getSimpleName(), "army tutorial completed");
            this.removeTutorial();
            return;
        }
        if (this.getCurrentTarget() != null) {
            this.showPoint(this.getCurrentTarget());
            return;
        }
        TutorialStepData step = this.storage.tutorialStep.get(tutorial.tutorialStepId);
        if (step.isFinishStep()) {
            tutorial.completed = true;
        }
        AvatarData avatar = this.model.player.selectedAvatar;
        Gdx.app.log("", "unit size" + avatar.units.size);
        int numUnits = avatar.numUnits;
        Gdx.app.log("", "unit size numUnits" + numUnits);
        boolean unitStep = numUnits < 3;
        boolean skipStep = false;
        switch (step.step) {
            case 1: {
                if (!unitStep) {
                    skipStep = true;
                    break;
                }
                this.showTutorialOnBarrack();
                break;
            }
            case 2: {
                if (!unitStep) {
                    skipStep = true;
                    break;
                }
                this.showTutorialStep2();
                break;
            }
            case 3: {
                if (!unitStep) {
                    skipStep = true;
                    break;
                }
                this.searchRequiredSlot();
                break;
            }
            case 4: {
                if (!unitStep) {
                    skipStep = true;
                    break;
                }
                this.searchRequiredSlot();
                break;
            }
            case 5: {
                if (this.barrackWindow == null) {
                    skipStep = true;
                    break;
                }
                this.showOnBuyButton();
                break;
            }
            case 6: {
                skipStep = true;
                break;
            }
            case 7: {
                if (this.barrackWindow != null) break;
                skipStep = true;
            }
        }
        TutorialStepData nextStep = this.storage.tutorialStep.getNextTutorialStep(tutorial.tutorialId, tutorial.tutorialStepId);
        if (nextStep != null) {
            tutorial.tutorialStepId = nextStep.id;
            if (!this.windowManager.hasOpenedWindowByClass(TutorialWindow.class) && this.getCurrentTarget() != null) {
                this.showPoint(this.getCurrentTarget());
            }
        } else {
            this.hidePointer();
            this.removeTutorial();
            return;
        }
        if (skipStep) {
            this.nextStep();
        }
    }

    private void showTutorialStep2() {
        this.searchRequiredSlot();
    }

    private void showOnBuyButton() {
        this.targets.add(this.barrackWindow.getBuyButton());
        this.showHint(this.model.lang.get("tutorial.army.restore_army"));
    }

    private void showOnCloseButton() {
        this.targets.add(this.barrackWindow.getCloseButton());
    }

    private void showTutorialOnBarrack() {
        Building building = this.screen.getBuildingManager().getBuildingByType("barrack");
        this.targets.add(building);
        this.showHint(this.model.lang.get("tutorial.army.show_barrack"));
    }

    private void searchRequiredSlot() {
        AvatarData avatar = this.model.player.selectedAvatar;
        Array<UnitData> units = avatar.units;
        if (units.size == 3) {
            this.removeTutorial();
            return;
        }
        Array<UnitTypeData> unitTypes = this.storage.unitType.getAll();
        int numUnitAvail = 0;
        for (UnitTypeData type : unitTypes) {
            if (avatar.level < type.minLevel) continue;
            ++numUnitAvail;
        }
        boolean allUnitsAvail = numUnitAvail == 3;
        UnitTypeData foundType = null;
        for (UnitTypeData type : unitTypes) {
            int numUnitsByType = avatar.getNumUnitsType(type.id);
            if (avatar.level < type.minLevel || (!allUnitsAvail || numUnitsByType != 0) && (allUnitsAvail || numUnitsByType >= 2)) continue;
            foundType = type;
            break;
        }
        if (foundType == null || this.barrackWindow == null) {
            return;
        }
        UnitSlot targetSlot = this.barrackWindow.getUnitSlotByType(foundType.id);
        if (targetSlot.getUnitTypeData().id == this.barrackWindow.getCurrentUnitType().id) {
            this.targets.add(targetSlot.getCreateBtn());
        } else {
            this.targets.add(targetSlot.getUnit());
        }
    }

    @Override
    public void dispose() {
        this.tutorialPoint.stop();
        this.model.removeListeners(this);
        this.windowManager.removeListener(this.windowOpenedListener);
    }
}

